﻿//
//Released under GPLv3, U2-CSM
//author: Giton<adm@subelf.net>, 20160503
//

using System;
using Spp2PgsNet;
using BluraySharp.Common;
using System.IO;

namespace Spp2PgsNetTest
{

	//依赖于BluraySharp.Definations与Spp2PgsNet_clr*.dll
	//运行时依赖于xy-VSSppf*.dll（通过Spp2PgsNet_clr*.dll调用）
	
	class Program
	{
		class MySettings : IS2PSettings	//喂给Spp2Pgs的全局参数，以下为建议值
		{
			public bool IsForcingEpochZeroStart { get { return true; } }	//前黑：开启

			public bool IsForcingTmtCompat { get { return false; } }	//放宽标准：禁止

			public ulong MaxCachingSize { get { return 1UL << 32; } }	//预判临时文件体积：4G

			public int MaxImageBlockSize { get { return 0; } }  //图片分割精度：自动
		}

		class MyLogger : IS2PLogger	//接受输出的日志信息
		{
			public void Vlog(int level, string msg)
			{
				if(level < 127) Console.Write(msg);
			}
		}

		static void Main(string[] args)
		{
			int frameOffset = 0;

			using (Spp2Pgs tS2P = new Spp2Pgs(new MySettings(), new MyLogger()))	//创建S2P对象
			using (var tCtx = tS2P.CreateSubPicProviderContext())	//创建VSSppf的上下文对象
			using (var tOutputStream = new FileStream(@"X:\Sayas1011con.sup", FileMode.Create))	//创建输出的Pgs文件
			using (var tOutput = tS2P.CreatePgsEncoder(tOutputStream, BdViFormat.Vi1080i, BdViFrameRate.Vi23, frameOffset)) //创建Pgs编码器，绑定到输出文件
			{
				//从输入文件1创建字幕SubPicProvider(Spp)
				using (var tSpp = tS2P.CreateSubPicProvider(tCtx, new FileInfo(@"X:\Illya.ass")))
				{
					//创建Advisor，自动分析并记录字幕动态变化
					var tAdv =
						tS2P.CreateSppFrameStreamAdvisor(tSpp, BdViFormat.Vi1080p, BdViFrameRate.Vi23,
						-1, -1, frameOffset);	//第一段字幕正常从0开始

					//从Spp创建字幕渲染器
					using (var tInput = tS2P.CreateFrameStream(tSpp, tAdv))
					{
						//使用S2P将读出的字幕帧输出至Pgs编码器
						tS2P.Encode(tInput, tOutput, null);
						//完工
					}

				}

				//第二段字幕向后移若干帧
				frameOffset = 34560;

				//从输入文件1创建字幕SubPicProvider(Spp)
				using (var tSpp = tS2P.CreateSubPicProvider(tCtx, new FileInfo(@"X:\Chino.ass")))
				{
					var tAdv =
						tS2P.CreateSppFrameStreamAdvisor(tSpp, BdViFormat.Vi1080p, BdViFrameRate.Vi23,
						-1, -1, frameOffset);   //指定偏移量

					//从Spp创建字幕渲染器
					using (var tInput = tS2P.CreateFrameStream(tSpp, tAdv))
					{
						//读字幕帧输出至Pgs编码器
						tS2P.Encode(tInput, tOutput, null);
						//完工
					}

				}
			}

			//GPLv3
		}
	}
}
