/* Copyright (C) 2016-2025 sheepChat <https://sheep.chat>, LLC - All Rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * Proprietary and confidential
 * Written by Valeriy Evstafev <nebel@creatic.pw>, April 2025
 */

var __assign=this&&this.__assign||function(){return(__assign=Object.assign||function(r){for(var n,t=1,e=arguments.length;t<e;t++)for(var i in n=arguments[t])Object.prototype.hasOwnProperty.call(n,i)&&(r[i]=n[i]);return r}).apply(this,arguments)},__read=this&&this.__read||function(r,n){var t="function"==typeof Symbol&&r[Symbol.iterator];if(!t)return r;var e,i,o=t.call(r),s=[];try{for(;(void 0===n||0<n--)&&!(e=o.next()).done;)s.push(e.value)}catch(r){i={error:r}}finally{try{e&&!e.done&&(t=o.return)&&t.call(o)}finally{if(i)throw i.error}}return s},__spreadArray=this&&this.__spreadArray||function(r,n){for(var t=0,e=n.length,i=r.length;t<e;t++,i++)r[i]=n[t];return r};const{isBigint,isDate,isInfinite,isMap,isNaNValue,isRegExp,isSet,isUndefined,isSymbol,isArray,isError,isTypedArray,isURL}=require("./is"),findArr=require("./util")["findArr"];function simpleTransformation(r,n,t,e){return{isApplicable:r,annotation:n,transform:t,untransform:e}}var simpleRules=[simpleTransformation(isUndefined,"undefined",function(){return null},function(){}),simpleTransformation(isBigint,"bigint",function(r){return r.toString()},function(r){return"undefined"!=typeof BigInt?BigInt(r):(console.error("Please add a BigInt polyfill."),r)}),simpleTransformation(isDate,"Date",function(r){return r.toISOString()},function(r){return new Date(r)}),simpleTransformation(isError,"Error",function(n,r){var t={name:n.name,message:n.message};return r.allowedErrorProps.forEach(function(r){t[r]=n[r]}),t},function(n,r){var t=new Error(n.message);return t.name=n.name,t.stack=n.stack,r.allowedErrorProps.forEach(function(r){t[r]=n[r]}),t}),simpleTransformation(isRegExp,"regexp",function(r){return""+r},function(r){var n=r.slice(1,r.lastIndexOf("/")),r=r.slice(r.lastIndexOf("/")+1);return new RegExp(n,r)}),simpleTransformation(isSet,"set",function(r){return __spreadArray([],__read(r.values()))},function(r){return new Set(r)}),simpleTransformation(isMap,"map",function(r){return __spreadArray([],__read(r.entries()))},function(r){return new Map(r)}),simpleTransformation(function(r){return isNaNValue(r)||isInfinite(r)},"number",function(r){return isNaNValue(r)?"NaN":0<r?"Infinity":"-Infinity"},Number),simpleTransformation(function(r){return 0===r&&1/r==-1/0},"number",function(){return"-0"},Number),simpleTransformation(isURL,"URL",function(r){return r.toString()},function(r){return new URL(r)})];function compositeTransformation(r,n,t,e){return{isApplicable:r,annotation:n,transform:t,untransform:e}}var symbolRule=compositeTransformation(function(r,n){return!!isSymbol(r)&&!!n.symbolRegistry.getIdentifier(r)},function(r,n){return["symbol",n.symbolRegistry.getIdentifier(r)]},function(r){return r.description},function(r,n,t){t=t.symbolRegistry.getValue(n[1]);if(t)return t;throw new Error("Trying to deserialize unknown symbol")}),constructorToName=[Int8Array,Uint8Array,Int16Array,Uint16Array,Int32Array,Uint32Array,Float32Array,Float64Array,Uint8ClampedArray].reduce(function(r,n){return r[n.name]=n,r},{}),typedArrayRule=compositeTransformation(isTypedArray,function(r){return["typed-array",r.constructor.name]},function(r){return __spreadArray([],__read(r))},function(r,n){n=constructorToName[n[1]];if(n)return new n(r);throw new Error("Trying to deserialize unknown typed array")});function isInstanceOfRegisteredClass(r,n){return!(null==r||!r.constructor||!n.classRegistry.getIdentifier(r.constructor))}var classRule=compositeTransformation(isInstanceOfRegisteredClass,function(r,n){return["class",n.classRegistry.getIdentifier(r.constructor)]},function(n,r){var t,r=r.classRegistry.getAllowedProps(n.constructor);return r?(t={},r.forEach(function(r){t[r]=n[r]}),t):__assign({},n)},function(r,n,t){t=t.classRegistry.getValue(n[1]);if(t)return Object.assign(Object.create(t.prototype),r);throw new Error("Trying to deserialize unknown class - check https://github.com/blitz-js/superjson/issues/116#issuecomment-773996564")}),customRule=compositeTransformation(function(r,n){return!!n.customTransformerRegistry.findApplicable(r)},function(r,n){return["custom",n.customTransformerRegistry.findApplicable(r).name]},function(r,n){return n.customTransformerRegistry.findApplicable(r).serialize(r)},function(r,n,t){t=t.customTransformerRegistry.findByName(n[1]);if(t)return t.deserialize(r);throw new Error("Trying to deserialize unknown custom value")}),compositeRules=[classRule,symbolRule,customRule,typedArrayRule],transformValue=function(n,t){var r=findArr(compositeRules,function(r){return r.isApplicable(n,t)});return r?{value:r.transform(n,t),type:r.annotation(n,t)}:(r=findArr(simpleRules,function(r){return r.isApplicable(n,t)}))?{value:r.transform(n,t),type:r.annotation}:void 0},simpleRulesByAnnotation={},untransformValue=(simpleRules.forEach(function(r){simpleRulesByAnnotation[r.annotation]=r}),function(r,n,t){if(!isArray(n)){var e=simpleRulesByAnnotation[n];if(e)return e.untransform(r,t);throw new Error("Unknown transformation: "+n)}switch(n[0]){case"symbol":return symbolRule.untransform(r,n,t);case"class":return classRule.untransform(r,n,t);case"custom":return customRule.untransform(r,n,t);case"typed-array":return typedArrayRule.untransform(r,n,t);default:throw new Error("Unknown transformation: "+n)}});module.exports={isInstanceOfRegisteredClass:isInstanceOfRegisteredClass,transformValue:transformValue,untransformValue:untransformValue};