/* Copyright (C) 2016-2025 sheepChat <https://sheep.chat>, LLC - All Rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * Proprietary and confidential
 * Written by Valeriy Evstafev <nebel@creatic.pw>, April 2025
 */

function getType(e){return Object.prototype.toString.call(e).slice(8,-1)}function isUndefined(e){return"Undefined"===getType(e)}function isNull(e){return"Null"===getType(e)}function isPlainObject(e){return"Object"===getType(e)&&e.constructor===Object&&Object.getPrototypeOf(e)===Object.prototype}function isObject(e){return isPlainObject(e)}function isEmptyObject(e){return isPlainObject(e)&&0===Object.keys(e).length}function isFullObject(e){return isPlainObject(e)&&0<Object.keys(e).length}function isAnyObject(e){return"Object"===getType(e)}function isObjectLike(e){return isAnyObject(e)}function isFunction(e){return"function"==typeof e}function isArray(e){return"Array"===getType(e)}function isFullArray(e){return isArray(e)&&0<e.length}function isEmptyArray(e){return isArray(e)&&0===e.length}function isString(e){return"String"===getType(e)}function isFullString(e){return isString(e)&&""!==e}function isEmptyString(e){return""===e}function isNumber(e){return"Number"===getType(e)&&!isNaN(e)}function isPositiveNumber(e){return isNumber(e)&&0<e}function isNegativeNumber(e){return isNumber(e)&&e<0}function isBoolean(e){return"Boolean"===getType(e)}function isRegExp(e){return"RegExp"===getType(e)}function isMap(e){return"Map"===getType(e)}function isWeakMap(e){return"WeakMap"===getType(e)}function isSet(e){return"Set"===getType(e)}function isWeakSet(e){return"WeakSet"===getType(e)}function isSymbol(e){return"Symbol"===getType(e)}function isDate(e){return"Date"===getType(e)&&!isNaN(e)}function isBlob(e){return"Blob"===getType(e)}function isFile(e){return"File"===getType(e)}function isPromise(e){return"Promise"===getType(e)}function isError(e){return"Error"===getType(e)}function isNaNValue(e){return"Number"===getType(e)&&isNaN(e)}function isPrimitive(e){return isBoolean(e)||isNull(e)||isUndefined(e)||isNumber(e)||isString(e)||isSymbol(e)}const isNullOrUndefined=isOneOf(isNull,isUndefined);function isOneOf(i,t,n,r,s){return e=>i(e)||t(e)||!!n&&n(e)||!!r&&r(e)||!!s&&s(e)}function isType(e,i){if(!(i instanceof Function))throw new TypeError("Type must be a function");var t;if(Object.prototype.hasOwnProperty.call(i,"prototype"))return t=i.name,getType(e)===t||Boolean(e&&e.constructor===i);throw new TypeError("Type is not a class")}module.exports={getType:getType,isAnyObject:isAnyObject,isArray:isArray,isBlob:isBlob,isBoolean:isBoolean,isDate:isDate,isEmptyArray:isEmptyArray,isEmptyObject:isEmptyObject,isEmptyString:isEmptyString,isError:isError,isFile:isFile,isFullArray:isFullArray,isFullObject:isFullObject,isFullString:isFullString,isFunction:isFunction,isMap:isMap,isNaNValue:isNaNValue,isNegativeNumber:isNegativeNumber,isNull:isNull,isNullOrUndefined:isNullOrUndefined,isNumber:isNumber,isObject:isObject,isObjectLike:isObjectLike,isOneOf:isOneOf,isPlainObject:isPlainObject,isPositiveNumber:isPositiveNumber,isPrimitive:isPrimitive,isPromise:isPromise,isRegExp:isRegExp,isSet:isSet,isString:isString,isSymbol:isSymbol,isType:isType,isUndefined:isUndefined,isWeakMap:isWeakMap,isWeakSet:isWeakSet};