/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptolib.common;

import java.lang.ref.WeakReference;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Supplier;

public class ObjectPool<T> {
    private final Queue<WeakReference<T>> returnedInstances = new ConcurrentLinkedQueue<WeakReference<T>>();
    private final Supplier<T> factory;

    public ObjectPool(Supplier<T> factory) {
        this.factory = factory;
    }

    public Lease<T> get() {
        WeakReference<T> ref;
        while ((ref = this.returnedInstances.poll()) != null) {
            Object cached = ref.get();
            if (cached == null) continue;
            return new Lease(this, cached);
        }
        return new Lease(this, this.factory.get());
    }

    public static class Lease<T>
    implements AutoCloseable,
    Supplier<T> {
        private final ObjectPool<T> pool;
        private T obj;

        private Lease(ObjectPool<T> pool, T obj) {
            this.pool = pool;
            this.obj = obj;
        }

        @Override
        public T get() {
            return this.obj;
        }

        @Override
        public void close() {
            ((ObjectPool)this.pool).returnedInstances.add(new WeakReference<T>(this.obj));
            this.obj = null;
        }
    }
}

