/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.frontend.webdav.mount;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.cryptomator.frontend.webdav.WebDavServerHandle;
import org.cryptomator.frontend.webdav.mount.AbstractMount;
import org.cryptomator.frontend.webdav.mount.AbstractMountBuilder;
import org.cryptomator.frontend.webdav.mount.ProcessUtil;
import org.cryptomator.frontend.webdav.servlet.WebDavServletController;
import org.cryptomator.integrations.common.OperatingSystem;
import org.cryptomator.integrations.common.Priority;
import org.cryptomator.integrations.mount.Mount;
import org.cryptomator.integrations.mount.MountBuilder;
import org.cryptomator.integrations.mount.MountCapability;
import org.cryptomator.integrations.mount.MountFailedException;
import org.cryptomator.integrations.mount.MountService;
import org.cryptomator.integrations.mount.Mountpoint;
import org.cryptomator.integrations.mount.UnmountFailedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Priority(value=50)
@OperatingSystem(value=OperatingSystem.Value.WINDOWS)
public class WindowsMounter
implements MountService {
    private static final Logger LOG = LoggerFactory.getLogger(WindowsMounter.class);
    private static final Pattern REG_QUERY_PROXY_OVERRIDES_PATTERN = Pattern.compile("\\s*ProxyOverride\\s+REG_SZ\\s+(.*)\\s*");
    private static final String SYSTEM_CHOSEN_MOUNTPOINT = "*";

    public String displayName() {
        return "WebDAV (Windows Explorer)";
    }

    public boolean isSupported() {
        return true;
    }

    public Set<MountCapability> capabilities() {
        return Set.of(MountCapability.LOOPBACK_PORT, MountCapability.LOOPBACK_HOST_NAME, MountCapability.MOUNT_AS_DRIVE_LETTER, MountCapability.MOUNT_TO_SYSTEM_CHOSEN_PATH, MountCapability.UNMOUNT_FORCED, MountCapability.VOLUME_ID, MountCapability.VOLUME_NAME);
    }

    public int getDefaultLoopbackPort() {
        return 0;
    }

    public MountBuilder forFileSystem(Path path) {
        return new MountBuilderImpl(path);
    }

    private static String parseSystemChosenMountpoin(String processOutput) {
        Pattern driveLetterPattern = Pattern.compile(" ([A-Z]:) ");
        Matcher m = driveLetterPattern.matcher(processOutput.trim());
        if (!m.find()) {
            throw new IllegalStateException("Output of `net use` must contain the drive letter");
        }
        return m.group(1);
    }

    private static void tuneProxyConfigSilently(URI uri) {
        try {
            WindowsMounter.tuneProxyConfig(uri);
        }
        catch (IOException | TimeoutException e) {
            LOG.warn("Tuning proxy config failed.", (Throwable)e);
        }
    }

    @Deprecated
    private static void tuneProxyConfig(URI uri) throws IOException, TimeoutException {
        ProcessBuilder regQuery = new ProcessBuilder("reg", "query", "\"HKCU\\Software\\Microsoft\\Windows\\CurrentVersion\\Internet Settings\"", "/v", "ProxyOverride");
        Process regQueryProcess = ProcessUtil.startAndWaitFor(regQuery, 5L, TimeUnit.SECONDS);
        String regQueryResult = regQueryProcess.inputReader(StandardCharsets.UTF_8).lines().collect(Collectors.joining("\n"));
        HashSet<Object> overrides = new HashSet<Object>();
        Matcher matcher = REG_QUERY_PROXY_OVERRIDES_PATTERN.matcher(regQueryResult);
        if (regQueryProcess.exitValue() == 0 && matcher.find()) {
            String originalOverrides = matcher.group(1);
            LOG.debug("Original Registry value for ProxyOverride is: {}", (Object)originalOverrides);
            overrides.addAll(Arrays.asList(originalOverrides.split(";")));
        }
        overrides.removeIf(s -> s.startsWith(uri.getHost() + ":"));
        overrides.add("<local>");
        overrides.add(uri.getHost());
        overrides.add(uri.getHost() + ":" + uri.getPort());
        String adjustedOverrides = String.join((CharSequence)";", overrides);
        ProcessBuilder regAdd = new ProcessBuilder("reg", "add", "\"HKCU\\Software\\Microsoft\\Windows\\CurrentVersion\\Internet Settings\"", "/v", "ProxyOverride", "/d", "\"" + adjustedOverrides + "\"", "/f");
        LOG.debug("Setting Registry value for ProxyOverride to: {}", (Object)adjustedOverrides);
        Process regAddProcess = ProcessUtil.startAndWaitFor(regAdd, 5L, TimeUnit.SECONDS);
        ProcessUtil.assertExitValue(regAddProcess, 0);
    }

    private static class MountBuilderImpl
    extends AbstractMountBuilder {
        private Path driveLetter;
        private String hostName;
        private String volumeName;

        public MountBuilderImpl(Path vfsRoot) {
            super(vfsRoot);
        }

        public MountBuilder setMountpoint(Path mountPoint) {
            if (mountPoint.getRoot().equals(mountPoint)) {
                this.driveLetter = mountPoint;
                return this;
            }
            throw new IllegalArgumentException("Mount point needs to be a drive letter");
        }

        public MountBuilder setLoopbackHostName(String hostName) {
            this.hostName = hostName;
            try {
                Path.of("\\\\" + hostName + "\\share", new String[0]);
                new URL("http", hostName, 80, "/");
            }
            catch (MalformedURLException | InvalidPathException e) {
                throw new IllegalArgumentException("hostName \"" + hostName + "\" does not satifsfy OS restrictions.", e);
            }
            return this;
        }

        public MountBuilder setVolumeName(String volumeName) {
            this.volumeName = volumeName;
            return this;
        }

        @Override
        protected String getContextPath() {
            return super.getContextPath() + "/" + this.volumeName;
        }

        @Override
        protected Mount mount(WebDavServerHandle serverHandle, WebDavServletController servlet, URI uri) throws MountFailedException {
            try {
                String actualMountpoint;
                WindowsMounter.tuneProxyConfigSilently(uri);
                String mountPoint = this.driveLetter == null ? WindowsMounter.SYSTEM_CHOSEN_MOUNTPOINT : this.driveLetter.toString().substring(0, 2);
                String uncPath = "\\\\" + (this.hostName == null ? uri.getHost() : this.hostName) + "@" + uri.getPort() + uri.getRawPath().replace('/', '\\');
                ProcessBuilder mount = new ProcessBuilder("net", "use", mountPoint, uncPath, "/persistent:no");
                Process mountProcess = mount.start();
                ProcessUtil.waitFor(mountProcess, 30L, TimeUnit.SECONDS);
                ProcessUtil.assertExitValue(mountProcess, 0);
                if (WindowsMounter.SYSTEM_CHOSEN_MOUNTPOINT.equals(mountPoint)) {
                    String stdout = mountProcess.inputReader(StandardCharsets.UTF_8).lines().collect(Collectors.joining("\n"));
                    actualMountpoint = WindowsMounter.parseSystemChosenMountpoin(stdout);
                } else {
                    actualMountpoint = mountPoint;
                }
                LOG.debug("Mounted {} on drive {}", (Object)uncPath, (Object)actualMountpoint);
                return new MountImpl(serverHandle, servlet, actualMountpoint, uncPath);
            }
            catch (IOException | TimeoutException e) {
                throw new MountFailedException(e);
            }
        }
    }

    private static class MountImpl
    extends AbstractMount {
        private final ProcessBuilder unmountCommand;
        private final ProcessBuilder forcedUnmountCommand;
        private final Path mountpoint;
        private final String uncPath;
        private final AtomicBoolean isUnmounted;

        public MountImpl(WebDavServerHandle serverHandle, WebDavServletController servlet, String driveLetter, String uncPath) {
            super(serverHandle, servlet);
            this.unmountCommand = new ProcessBuilder("net", "use", driveLetter, "/delete", "/no");
            this.forcedUnmountCommand = new ProcessBuilder("net", "use", driveLetter, "/delete", "/yes");
            this.mountpoint = Path.of(driveLetter + "\\", new String[0]);
            this.uncPath = uncPath;
            this.isUnmounted = new AtomicBoolean(false);
        }

        public Mountpoint getMountpoint() {
            return Mountpoint.forPath((Path)this.mountpoint);
        }

        @Override
        public void unmount() throws UnmountFailedException {
            this.unmount(this.unmountCommand);
        }

        public void unmountForced() throws UnmountFailedException {
            this.unmount(this.forcedUnmountCommand);
        }

        private synchronized void unmount(ProcessBuilder command) throws UnmountFailedException {
            if (this.isUnmounted.get()) {
                return;
            }
            try {
                if (!this.isUnmounted()) {
                    ProcessUtil.assertExitValue(ProcessUtil.startAndWaitFor(command, 5L, TimeUnit.SECONDS), 0);
                }
                super.unmount();
                this.isUnmounted.set(true);
            }
            catch (IOException | TimeoutException e) {
                throw new UnmountFailedException(e);
            }
        }

        private boolean isUnmounted() {
            try {
                ProcessBuilder determineMP = new ProcessBuilder("net", "use");
                Process determineMPProcess = ProcessUtil.startAndWaitFor(determineMP, 5L, TimeUnit.SECONDS);
                ProcessUtil.assertExitValue(determineMPProcess, 0);
                return determineMPProcess.inputReader(StandardCharsets.UTF_8).lines().noneMatch(l -> l.contains(this.uncPath));
            }
            catch (IOException | TimeoutException e) {
                return false;
            }
        }
    }
}

