/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs.migration.v7;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.SecureRandom;
import java.util.EnumSet;
import javax.inject.Inject;
import org.cryptomator.cryptofs.FileNameTooLongException;
import org.cryptomator.cryptofs.common.BackupHelper;
import org.cryptomator.cryptofs.common.DeletingFileVisitor;
import org.cryptomator.cryptofs.common.FileSystemCapabilityChecker;
import org.cryptomator.cryptofs.migration.api.MigrationContinuationListener;
import org.cryptomator.cryptofs.migration.api.MigrationProgressListener;
import org.cryptomator.cryptofs.migration.api.Migrator;
import org.cryptomator.cryptofs.migration.v7.MigratingVisitor;
import org.cryptomator.cryptofs.migration.v7.PreMigrationVisitor;
import org.cryptomator.cryptolib.api.CryptoException;
import org.cryptomator.cryptolib.api.Masterkey;
import org.cryptomator.cryptolib.common.MasterkeyFileAccess;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Version7Migrator
implements Migrator {
    private static final Logger LOG = LoggerFactory.getLogger(Version7Migrator.class);
    private final SecureRandom csprng;

    @Inject
    public Version7Migrator(SecureRandom csprng) {
        this.csprng = csprng;
    }

    @Override
    public void migrate(Path vaultRoot, String vaultConfigFilename, String masterkeyFilename, CharSequence passphrase, MigrationProgressListener progressListener, MigrationContinuationListener continuationListener) throws CryptoException, IOException {
        LOG.info("Upgrading {} from version 6 to version 7.", (Object)vaultRoot);
        progressListener.update(MigrationProgressListener.ProgressState.INITIALIZING, 0.0);
        Path masterkeyFile = vaultRoot.resolve(masterkeyFilename);
        MasterkeyFileAccess masterkeyFileAccess = new MasterkeyFileAccess(new byte[0], this.csprng);
        try (Masterkey masterkey = masterkeyFileAccess.load(masterkeyFile, passphrase);){
            PreMigrationVisitor preMigrationVisitor;
            Path masterkeyBackupFile = BackupHelper.attemptBackup(masterkeyFile);
            LOG.info("Backed up masterkey from {} to {}.", (Object)masterkeyFile.getFileName(), (Object)masterkeyBackupFile.getFileName());
            int filenameLengthLimit = FileSystemCapabilityChecker.determineSupportedCiphertextFileNameLength(vaultRoot.resolve("c"), 46, 28, 220);
            int pathLengthLimit = filenameLengthLimit + 48;
            if (filenameLengthLimit >= 220) {
                LOG.info("Underlying file system meets filename length requirements.");
                preMigrationVisitor = new PreMigrationVisitor(vaultRoot, false);
            } else {
                LOG.warn("Underlying file system only supports names with up to {} chars (required: 220). Asking for user feedback...", (Object)filenameLengthLimit);
                MigrationContinuationListener.ContinuationResult result = continuationListener.continueMigrationOnEvent(MigrationContinuationListener.ContinuationEvent.REQUIRES_FULL_VAULT_DIR_SCAN);
                switch (result) {
                    case PROCEED: {
                        preMigrationVisitor = new PreMigrationVisitor(vaultRoot, true);
                        break;
                    }
                    case CANCEL: {
                        LOG.info("Migration canceled by user.");
                        return;
                    }
                    default: {
                        throw new IllegalStateException("Unexpected result " + String.valueOf((Object)result));
                    }
                }
            }
            Path dataDir = vaultRoot.resolve("d");
            Files.walkFileTree(dataDir, EnumSet.noneOf(FileVisitOption.class), 3, preMigrationVisitor);
            if (preMigrationVisitor.getMaxCiphertextPathLength() > (long)pathLengthLimit) {
                LOG.error("Migration aborted due to unsupported path length (required {}) of underlying file system (supports {}). Vault is unchanged.", (Object)preMigrationVisitor.getMaxCiphertextPathLength(), (Object)pathLengthLimit);
                throw new FileNameTooLongException(preMigrationVisitor.getLongestPath().toString(), filenameLengthLimit);
            }
            if (preMigrationVisitor.getMaxCiphertextNameLength() > (long)filenameLengthLimit) {
                LOG.error("Migration aborted due to unsupported filename length (required {}) of underlying file system (supports {}). Vault is unchanged.", (Object)preMigrationVisitor.getMaxCiphertextNameLength(), (Object)filenameLengthLimit);
                throw new FileNameTooLongException(preMigrationVisitor.getPathWithLongestName().toString(), filenameLengthLimit);
            }
            long toBeMigrated = preMigrationVisitor.getTotalFileCount();
            LOG.info("Starting migration of {} files", (Object)toBeMigrated);
            if (toBeMigrated > 0L) {
                this.migrateFileNames(vaultRoot, progressListener, toBeMigrated);
            }
            progressListener.update(MigrationProgressListener.ProgressState.FINALIZING, 0.0);
            Files.walkFileTree(vaultRoot.resolve("m"), DeletingFileVisitor.INSTANCE);
            masterkeyFileAccess.persist(masterkey, masterkeyFile, passphrase, 7);
            LOG.info("Updated masterkey.");
        }
        LOG.info("Upgraded {} from version 6 to version 7.", (Object)vaultRoot);
    }

    private void migrateFileNames(Path vaultRoot, MigrationProgressListener progressListener, long totalFiles) throws IOException {
        assert (totalFiles > 0L);
        Path dataDir = vaultRoot.resolve("d");
        Files.walkFileTree(dataDir, EnumSet.noneOf(FileVisitOption.class), 3, new MigratingVisitor(vaultRoot, progressListener, totalFiles));
    }
}

