/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.io.BaseEncoding;
import java.io.IOException;
import java.nio.file.FileSystemException;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.cryptomator.cryptofs.CryptoFileSystemScoped;
import org.cryptomator.cryptofs.DirectoryIdBackup;
import org.cryptomator.cryptofs.LongFileNameProvider;
import org.cryptomator.cryptofs.PathToVault;
import org.cryptomator.cryptofs.common.StringUtils;
import org.cryptomator.cryptolib.api.CryptoException;
import org.cryptomator.cryptolib.api.Cryptor;
import org.cryptomator.cryptolib.api.FileNameCryptor;

@CryptoFileSystemScoped
class FileNameDecryptor {
    private final DirectoryIdBackup dirIdBackup;
    private final LongFileNameProvider longFileNameProvider;
    private final Path vaultPath;
    private final FileNameCryptor fileNameCryptor;

    @Inject
    public FileNameDecryptor(@PathToVault Path vaultPath, Cryptor cryptor, DirectoryIdBackup dirIdBackup, LongFileNameProvider longFileNameProvider) {
        this.vaultPath = vaultPath;
        this.fileNameCryptor = cryptor.fileNameCryptor();
        this.dirIdBackup = dirIdBackup;
        this.longFileNameProvider = longFileNameProvider;
    }

    public String decryptFilename(Path ciphertextNode) throws IOException, UnsupportedOperationException {
        this.validatePath(ciphertextNode.toAbsolutePath());
        return this.decryptFilenameInternal(ciphertextNode);
    }

    @VisibleForTesting
    String decryptFilenameInternal(Path ciphertextNode) throws IOException, UnsupportedOperationException {
        String cipherNodeExtension;
        byte[] dirId = null;
        try {
            dirId = this.dirIdBackup.read(ciphertextNode);
        }
        catch (NoSuchFileException e) {
            throw new UnsupportedOperationException("Directory does not have a dirid.c9r file.");
        }
        catch (IllegalStateException | CryptoException e) {
            throw new FileSystemException(ciphertextNode.toString(), null, "Decryption of dirId backup file failed:" + String.valueOf(e));
        }
        String fullCipherNodeName = ciphertextNode.getFileName().toString();
        String actualEncryptedName = switch (cipherNodeExtension = fullCipherNodeName.substring(fullCipherNodeName.length() - 4)) {
            case ".c9r" -> StringUtils.removeEnd(fullCipherNodeName, ".c9r");
            case ".c9s" -> this.longFileNameProvider.inflate(ciphertextNode);
            default -> throw new IllegalStateException("SHOULD NOT REACH HERE");
        };
        try {
            return this.fileNameCryptor.decryptFilename(BaseEncoding.base64Url(), actualEncryptedName, (byte[][])new byte[][]{dirId});
        }
        catch (CryptoException e) {
            throw new FileSystemException(ciphertextNode.toString(), null, "Filname decryption failed:" + String.valueOf((Object)e));
        }
    }

    @VisibleForTesting
    void validatePath(Path absolutePath) {
        if (!this.belongsToVault(absolutePath)) {
            throw new IllegalArgumentException("Node %s is not a part of vault %s".formatted(absolutePath, this.vaultPath));
        }
        if (!this.isAtCipherNodeLevel(absolutePath)) {
            throw new IllegalArgumentException("Node %s is not located at depth 4 from vault storage root".formatted(absolutePath));
        }
        if (!this.hasCipherNodeExtension(absolutePath) || !this.hasMinimumFileNameLength(absolutePath)) {
            throw new IllegalArgumentException("Node %s does not end with %s or %s or filename is shorter than %d characters.".formatted(absolutePath, ".c9r", ".c9s", 28));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean hasCipherNodeExtension(Path p) {
        Path name = p.getFileName();
        if (name == null) return false;
        if (!Stream.of(".c9r", ".c9s").anyMatch(name.toString()::endsWith)) return false;
        return true;
    }

    boolean isAtCipherNodeLevel(Path absolutPah) {
        if (!absolutPah.isAbsolute()) {
            throw new IllegalArgumentException("Path " + String.valueOf(absolutPah) + "must be absolute");
        }
        return absolutPah.subpath(this.vaultPath.getNameCount(), absolutPah.getNameCount()).getNameCount() == 4;
    }

    boolean hasMinimumFileNameLength(Path p) {
        return p.getFileName().toString().length() >= 28;
    }

    boolean belongsToVault(Path p) {
        return p.startsWith(this.vaultPath);
    }
}

