/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.vaultoptions;

import java.util.ResourceBundle;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import javafx.beans.property.StringProperty;
import javafx.fxml.FXML;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.stage.Stage;
import javafx.util.StringConverter;
import javax.inject.Inject;
import org.cryptomator.common.settings.WhenUnlocked;
import org.cryptomator.common.vaults.Vault;
import org.cryptomator.ui.common.FxController;
import org.cryptomator.ui.controls.NumericTextField;
import org.cryptomator.ui.health.HealthCheckComponent;
import org.cryptomator.ui.vaultoptions.VaultOptionsScoped;
import org.cryptomator.ui.vaultoptions.VaultOptionsWindow;

@VaultOptionsScoped
public class GeneralVaultOptionsController
implements FxController {
    private static final int VAULTNAME_TRUNCATE_THRESHOLD = 50;
    private final Stage window;
    private final Vault vault;
    private final HealthCheckComponent.Builder healthCheckWindow;
    private final ResourceBundle resourceBundle;
    public TextField vaultName;
    public CheckBox unlockOnStartupCheckbox;
    public ChoiceBox<WhenUnlocked> actionAfterUnlockChoiceBox;
    public CheckBox lockAfterTimeCheckbox;
    public NumericTextField lockTimeInMinutesTextField;

    @Inject
    GeneralVaultOptionsController(@VaultOptionsWindow Stage window, @VaultOptionsWindow Vault vault, HealthCheckComponent.Builder healthCheckWindow, ResourceBundle resourceBundle) {
        this.window = window;
        this.vault = vault;
        this.healthCheckWindow = healthCheckWindow;
        this.resourceBundle = resourceBundle;
    }

    @FXML
    public void initialize() {
        this.vaultName.textProperty().set((Object)((String)this.vault.getVaultSettings().displayName.get()));
        this.vaultName.focusedProperty().addListener(this::trimVaultNameOnFocusLoss);
        this.vaultName.setTextFormatter(new TextFormatter(this::checkVaultNameLength));
        this.unlockOnStartupCheckbox.selectedProperty().bindBidirectional((Property)this.vault.getVaultSettings().unlockAfterStartup);
        this.actionAfterUnlockChoiceBox.getItems().addAll((Object[])WhenUnlocked.values());
        this.actionAfterUnlockChoiceBox.valueProperty().bindBidirectional(this.vault.getVaultSettings().actionAfterUnlock);
        this.actionAfterUnlockChoiceBox.setConverter((StringConverter)new WhenUnlockedConverter(this.resourceBundle));
        this.lockAfterTimeCheckbox.selectedProperty().bindBidirectional((Property)this.vault.getVaultSettings().autoLockWhenIdle);
        Bindings.bindBidirectional((Property)this.lockTimeInMinutesTextField.textProperty(), (Property)this.vault.getVaultSettings().autoLockIdleSeconds, (StringConverter)new IdleTimeSecondsConverter());
    }

    private void trimVaultNameOnFocusLoss(Observable observable, Boolean wasFocussed, Boolean isFocussed) {
        StringProperty displayNameSetting = this.vault.getVaultSettings().displayName;
        if (!isFocussed.booleanValue()) {
            String trimmed = this.vaultName.getText().trim();
            if (!trimmed.isEmpty()) {
                displayNameSetting.set((Object)trimmed);
            } else {
                this.vaultName.setText((String)displayNameSetting.get());
            }
        }
    }

    private TextFormatter.Change checkVaultNameLength(TextFormatter.Change change) {
        if (change.isContentChange() && change.getControlNewText().length() > 50) {
            return null;
        }
        return change;
    }

    public void startHealthCheck() {
        this.healthCheckWindow.vault(this.vault).owner(this.window).build().showHealthCheckWindow();
    }

    private static class WhenUnlockedConverter
    extends StringConverter<WhenUnlocked> {
        private final ResourceBundle resourceBundle;

        public WhenUnlockedConverter(ResourceBundle resourceBundle) {
            this.resourceBundle = resourceBundle;
        }

        public String toString(WhenUnlocked obj) {
            return this.resourceBundle.getString(obj.getDisplayName());
        }

        public WhenUnlocked fromString(String string) {
            throw new UnsupportedOperationException();
        }
    }

    private static class IdleTimeSecondsConverter
    extends StringConverter<Number> {
        private IdleTimeSecondsConverter() {
        }

        public String toString(Number seconds) {
            int minutes = seconds.intValue() / 60;
            return Integer.toString(minutes);
        }

        public Number fromString(String string) {
            try {
                int minutes = Integer.valueOf(string);
                return minutes * 60;
            }
            catch (NumberFormatException e) {
                return 0;
            }
        }
    }
}

