/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.traymenu;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.collections.ObservableList;
import javax.inject.Inject;
import org.apache.commons.lang3.SystemUtils;
import org.cryptomator.common.vaults.Vault;
import org.cryptomator.common.vaults.VaultListManager;
import org.cryptomator.integrations.tray.ActionItem;
import org.cryptomator.integrations.tray.SeparatorItem;
import org.cryptomator.integrations.tray.SubMenuItem;
import org.cryptomator.integrations.tray.TrayIconLoader;
import org.cryptomator.integrations.tray.TrayMenuController;
import org.cryptomator.integrations.tray.TrayMenuException;
import org.cryptomator.integrations.tray.TrayMenuItem;
import org.cryptomator.ui.common.VaultService;
import org.cryptomator.ui.fxapp.FxApplicationTerminator;
import org.cryptomator.ui.fxapp.FxApplicationWindows;
import org.cryptomator.ui.preferences.SelectedPreferencesTab;
import org.cryptomator.ui.traymenu.TrayMenuScoped;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TrayMenuScoped
public class TrayMenuBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(TrayMenuBuilder.class);
    private static final String TRAY_ICON_MAC = "/img/tray_icon_mac@2x.png";
    private static final String TRAY_ICON_UNLOCKED_MAC = "/img/tray_icon_unlocked_mac@2x.png";
    private static final String TRAY_ICON = "/img/tray_icon.png";
    private static final String TRAY_ICON_UNLOCKED = "/img/tray_icon_unlocked.png";
    private final ResourceBundle resourceBundle;
    private final VaultService vaultService;
    private final FxApplicationWindows appWindows;
    private final FxApplicationTerminator appTerminator;
    private final ObservableList<Vault> vaults;
    private final TrayMenuController trayMenu;
    private volatile boolean initialized;

    @Inject
    TrayMenuBuilder(ResourceBundle resourceBundle, VaultService vaultService, FxApplicationWindows appWindows, FxApplicationTerminator appTerminator, ObservableList<Vault> vaults, Optional<TrayMenuController> trayMenu) {
        this.resourceBundle = resourceBundle;
        this.vaultService = vaultService;
        this.appWindows = appWindows;
        this.appTerminator = appTerminator;
        this.vaults = vaults;
        this.trayMenu = trayMenu.orElse(null);
    }

    public synchronized void initTrayMenu() {
        Preconditions.checkState((!this.initialized ? 1 : 0) != 0, (Object)"tray icon already initialized");
        this.vaults.addListener(this::vaultListChanged);
        this.vaults.forEach(v -> v.displayNameProperty().addListener(this::vaultListChanged));
        try {
            this.trayMenu.showTrayIcon(loader -> {
                TrayIconLoader trayIconLoader = loader;
                Objects.requireNonNull(trayIconLoader);
                TrayIconLoader selector0$temp = trayIconLoader;
                int index$1 = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TrayIconLoader.PngData.class, TrayIconLoader.FreedesktopIconName.class}, (TrayIconLoader)selector0$temp, index$1)) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case 0: {
                        TrayIconLoader.PngData l = (TrayIconLoader.PngData)selector0$temp;
                        l.loadPng(this.getAppropriateTrayIconImage());
                        break;
                    }
                    case 1: {
                        TrayIconLoader.FreedesktopIconName l = (TrayIconLoader.FreedesktopIconName)selector0$temp;
                        l.lookupByName(this.getAppropriateFreedesktopIconName());
                    }
                }
            }, this::showMainWindow, "Cryptomator");
            this.trayMenu.onBeforeOpenMenu(() -> {
                for (Vault vault : this.vaults) {
                    VaultListManager.redetermineVaultState(vault);
                }
            });
            this.rebuildMenu();
            this.initialized = true;
        }
        catch (TrayMenuException e) {
            LOG.error("Adding tray icon failed", (Throwable)e);
        }
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    private void vaultListChanged(Observable observable) {
        assert (Platform.isFxApplicationThread());
        this.trayMenu.updateTrayIcon(loader -> {
            TrayIconLoader trayIconLoader = loader;
            Objects.requireNonNull(trayIconLoader);
            TrayIconLoader selector0$temp = trayIconLoader;
            int index$1 = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TrayIconLoader.PngData.class, TrayIconLoader.FreedesktopIconName.class}, (TrayIconLoader)selector0$temp, index$1)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    TrayIconLoader.PngData l = (TrayIconLoader.PngData)selector0$temp;
                    l.loadPng(this.getAppropriateTrayIconImage());
                    break;
                }
                case 1: {
                    TrayIconLoader.FreedesktopIconName l = (TrayIconLoader.FreedesktopIconName)selector0$temp;
                    l.lookupByName(this.getAppropriateFreedesktopIconName());
                }
            }
        });
        this.rebuildMenu();
    }

    private void rebuildMenu() {
        ArrayList<Object> menu = new ArrayList<Object>();
        menu.add(new ActionItem(this.resourceBundle.getString("traymenu.showMainWindow"), this::showMainWindow));
        menu.add(new ActionItem(this.resourceBundle.getString("traymenu.showPreferencesWindow"), this::showPreferencesWindow));
        menu.add(new SeparatorItem());
        for (Vault vault : this.vaults) {
            List<TrayMenuItem> submenu = this.buildSubmenu(vault);
            String label = vault.isUnlocked() ? "* ".concat(vault.getDisplayName()) : vault.getDisplayName();
            menu.add(new SubMenuItem(label, submenu));
        }
        menu.add(new SeparatorItem());
        menu.add(new ActionItem(this.resourceBundle.getString("traymenu.lockAllVaults"), this::lockAllVaults, this.vaults.stream().anyMatch(Vault::isUnlocked)));
        menu.add(new ActionItem(this.resourceBundle.getString("traymenu.quitApplication"), this::quitApplication));
        try {
            this.trayMenu.updateTrayMenu(menu);
        }
        catch (TrayMenuException e) {
            LOG.error("Updating tray menu failed", (Throwable)e);
        }
    }

    private List<TrayMenuItem> buildSubmenu(Vault vault) {
        if (vault.isLocked()) {
            return List.of(new ActionItem(this.resourceBundle.getString("traymenu.vault.unlock"), () -> this.unlockVault(vault)));
        }
        if (vault.isUnlocked()) {
            return List.of(new ActionItem(this.resourceBundle.getString("traymenu.vault.lock"), () -> this.lockVault(vault)), new ActionItem(this.resourceBundle.getString("traymenu.vault.reveal"), () -> this.revealVault(vault)));
        }
        return List.of();
    }

    private void quitApplication() {
        this.appTerminator.terminate();
    }

    private void unlockVault(Vault vault) {
        this.appWindows.startUnlockWorkflow(vault, null);
    }

    private void lockVault(Vault vault) {
        this.appWindows.startLockWorkflow(vault, null);
    }

    private void lockAllVaults() {
        this.vaultService.lockAll((Collection<Vault>)this.vaults.filtered(Vault::isUnlocked), false);
    }

    private void revealVault(Vault vault) {
        this.vaultService.reveal(vault);
    }

    void showMainWindow() {
        this.appWindows.showMainWindow();
    }

    private void showPreferencesWindow() {
        this.appWindows.showPreferencesWindow(SelectedPreferencesTab.ANY);
    }

    private byte[] getAppropriateTrayIconImage() {
        byte[] byArray;
        block9: {
            boolean isAnyVaultUnlocked = this.vaults.stream().anyMatch(Vault::isUnlocked);
            String resourceName = SystemUtils.IS_OS_MAC_OSX ? (isAnyVaultUnlocked ? TRAY_ICON_UNLOCKED_MAC : TRAY_ICON_MAC) : (isAnyVaultUnlocked ? TRAY_ICON_UNLOCKED : TRAY_ICON);
            InputStream image = this.getClass().getResourceAsStream(resourceName);
            try {
                assert (image != null);
                byArray = image.readAllBytes();
                if (image == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (image != null) {
                        try {
                            image.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Failed to load tray icon image: " + resourceName, e);
                }
            }
            image.close();
        }
        return byArray;
    }

    private String getAppropriateFreedesktopIconName() {
        boolean isAnyVaultUnlocked = this.vaults.stream().anyMatch(Vault::isUnlocked);
        return isAnyVaultUnlocked ? "org.cryptomator.Cryptomator.tray-unlocked-symbolic" : "org.cryptomator.Cryptomator.tray-symbolic";
    }
}

