/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.preferences;

import dagger.Lazy;
import java.util.List;
import java.util.Optional;
import java.util.ResourceBundle;
import javafx.application.Application;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableStringValue;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.Button;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.TextField;
import javafx.util.StringConverter;
import javax.inject.Inject;
import org.cryptomator.common.ObservableUtil;
import org.cryptomator.common.settings.Settings;
import org.cryptomator.integrations.mount.MountCapability;
import org.cryptomator.integrations.mount.MountService;
import org.cryptomator.ui.common.FxController;
import org.cryptomator.ui.preferences.PreferencesScoped;

@PreferencesScoped
public class VolumePreferencesController
implements FxController {
    public static final String DOCS_MOUNTING_URL = "https://docs.cryptomator.org/desktop/volume-type/";
    public static final int MIN_PORT = 1024;
    public static final int MAX_PORT = 65535;
    private final Settings settings;
    private final ObservableValue<MountService> selectedMountService;
    private final ResourceBundle resourceBundle;
    private final ObservableValue<Boolean> loopbackPortSupported;
    private final ObservableValue<Boolean> mountToDirSupported;
    private final ObservableValue<Boolean> mountToDriveLetterSupported;
    private final ObservableValue<Boolean> mountFlagsSupported;
    private final ObservableValue<Boolean> readonlySupported;
    private final Lazy<Application> application;
    private final List<MountService> mountProviders;
    public ChoiceBox<MountService> volumeTypeChoiceBox;
    public TextField loopbackPortField;
    public Button loopbackPortApplyButton;

    @Inject
    VolumePreferencesController(Settings settings, Lazy<Application> application, List<MountService> mountProviders, ResourceBundle resourceBundle) {
        this.settings = settings;
        this.application = application;
        this.mountProviders = mountProviders;
        this.resourceBundle = resourceBundle;
        MountService fallbackProvider = mountProviders.stream().findFirst().orElse(null);
        this.selectedMountService = ObservableUtil.mapWithDefault(settings.mountService, serviceName -> mountProviders.stream().filter(s -> s.getClass().getName().equals(serviceName)).findFirst().orElse(fallbackProvider), fallbackProvider);
        this.loopbackPortSupported = this.selectedMountService.map(s -> s.hasCapability(MountCapability.LOOPBACK_PORT));
        this.mountToDirSupported = this.selectedMountService.map(s -> s.hasCapability(MountCapability.MOUNT_WITHIN_EXISTING_PARENT) || s.hasCapability(MountCapability.MOUNT_TO_EXISTING_DIR));
        this.mountToDriveLetterSupported = this.selectedMountService.map(s -> s.hasCapability(MountCapability.MOUNT_AS_DRIVE_LETTER));
        this.mountFlagsSupported = this.selectedMountService.map(s -> s.hasCapability(MountCapability.MOUNT_FLAGS));
        this.readonlySupported = this.selectedMountService.map(s -> s.hasCapability(MountCapability.READ_ONLY));
    }

    public void initialize() {
        this.volumeTypeChoiceBox.getItems().add(null);
        this.volumeTypeChoiceBox.getItems().addAll(this.mountProviders);
        this.volumeTypeChoiceBox.setConverter((StringConverter)new MountServiceConverter());
        boolean autoSelected = this.settings.mountService.get() == null;
        this.volumeTypeChoiceBox.getSelectionModel().select(autoSelected ? null : (MountService)this.selectedMountService.getValue());
        this.volumeTypeChoiceBox.valueProperty().addListener((observableValue, oldProvider, newProvider) -> {
            String toSet = Optional.ofNullable(newProvider).map(nP -> nP.getClass().getName()).orElse(null);
            this.settings.mountService.set((Object)toSet);
        });
        this.loopbackPortField.setText(String.valueOf(this.settings.port.get()));
        this.loopbackPortApplyButton.visibleProperty().bind((ObservableValue)this.settings.port.asString().isNotEqualTo((ObservableStringValue)this.loopbackPortField.textProperty()));
        this.loopbackPortApplyButton.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(this::validateLoopbackPort, (Observable[])new Observable[]{this.loopbackPortField.textProperty()}).not());
    }

    private boolean validateLoopbackPort() {
        try {
            int port = Integer.parseInt(this.loopbackPortField.getText());
            return port == 0 || port >= 1024 && port <= 65535;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public void doChangeLoopbackPort() {
        if (this.validateLoopbackPort()) {
            this.settings.port.set(Integer.parseInt(this.loopbackPortField.getText()));
        }
    }

    public ObservableValue<Boolean> loopbackPortSupportedProperty() {
        return this.loopbackPortSupported;
    }

    public boolean isLoopbackPortSupported() {
        return (Boolean)this.loopbackPortSupported.getValue();
    }

    public ObservableValue<Boolean> readonlySupportedProperty() {
        return this.readonlySupported;
    }

    public boolean isReadonlySupported() {
        return (Boolean)this.readonlySupported.getValue();
    }

    public ObservableValue<Boolean> mountToDirSupportedProperty() {
        return this.mountToDirSupported;
    }

    public boolean isMountToDirSupported() {
        return (Boolean)this.mountToDirSupported.getValue();
    }

    public ObservableValue<Boolean> mountToDriveLetterSupportedProperty() {
        return this.mountToDriveLetterSupported;
    }

    public boolean isMountToDriveLetterSupported() {
        return (Boolean)this.mountToDriveLetterSupported.getValue();
    }

    public ObservableValue<Boolean> mountFlagsSupportedProperty() {
        return this.mountFlagsSupported;
    }

    public boolean isMountFlagsSupported() {
        return (Boolean)this.mountFlagsSupported.getValue();
    }

    public void openDocs() {
        ((Application)this.application.get()).getHostServices().showDocument(DOCS_MOUNTING_URL);
    }

    private class MountServiceConverter
    extends StringConverter<MountService> {
        private MountServiceConverter() {
        }

        public String toString(MountService provider) {
            if (provider == null) {
                return VolumePreferencesController.this.resourceBundle.getString("preferences.volume.type.automatic");
            }
            return provider.displayName();
        }

        public MountService fromString(String string) {
            throw new UnsupportedOperationException();
        }
    }
}

