/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.preferences;

import java.util.List;
import java.util.Optional;
import javafx.application.Application;
import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.ToggleGroup;
import javafx.stage.Stage;
import javafx.util.StringConverter;
import javax.inject.Inject;
import org.cryptomator.common.Environment;
import org.cryptomator.common.settings.Settings;
import org.cryptomator.integrations.autostart.AutoStartProvider;
import org.cryptomator.integrations.autostart.ToggleAutoStartFailedException;
import org.cryptomator.integrations.common.NamedServiceProvider;
import org.cryptomator.integrations.keychain.KeychainAccessProvider;
import org.cryptomator.integrations.quickaccess.QuickAccessService;
import org.cryptomator.ui.common.FxController;
import org.cryptomator.ui.fxapp.FxApplicationWindows;
import org.cryptomator.ui.preferences.PreferencesScoped;
import org.cryptomator.ui.preferences.PreferencesWindow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PreferencesScoped
public class GeneralPreferencesController
implements FxController {
    private static final Logger LOG = LoggerFactory.getLogger(GeneralPreferencesController.class);
    private final Stage window;
    private final Settings settings;
    private final Optional<AutoStartProvider> autoStartProvider;
    private final List<QuickAccessService> quickAccessServices;
    private final Application application;
    private final Environment environment;
    private final List<KeychainAccessProvider> keychainAccessProviders;
    private final FxApplicationWindows appWindows;
    public CheckBox useKeychainCheckbox;
    public ChoiceBox<KeychainAccessProvider> keychainBackendChoiceBox;
    public CheckBox useQuickAccessCheckbox;
    public ChoiceBox<QuickAccessService> quickAccessServiceChoiceBox;
    public CheckBox startHiddenCheckbox;
    public CheckBox autoCloseVaultsCheckbox;
    public CheckBox debugModeCheckbox;
    public CheckBox autoStartCheckbox;
    public ToggleGroup nodeOrientation;

    @Inject
    GeneralPreferencesController(@PreferencesWindow Stage window, Settings settings, Optional<AutoStartProvider> autoStartProvider, List<KeychainAccessProvider> keychainAccessProviders, Application application, Environment environment, FxApplicationWindows appWindows) {
        this.window = window;
        this.settings = settings;
        this.autoStartProvider = autoStartProvider;
        this.keychainAccessProviders = keychainAccessProviders;
        this.quickAccessServices = QuickAccessService.get().toList();
        this.application = application;
        this.environment = environment;
        this.appWindows = appWindows;
    }

    @FXML
    public void initialize() {
        this.startHiddenCheckbox.selectedProperty().bindBidirectional((Property)this.settings.startHidden);
        this.autoCloseVaultsCheckbox.selectedProperty().bindBidirectional((Property)this.settings.autoCloseVaults);
        this.debugModeCheckbox.selectedProperty().bindBidirectional((Property)this.settings.debugMode);
        this.autoStartProvider.ifPresent(autoStart -> this.autoStartCheckbox.setSelected(autoStart.isEnabled()));
        ServiceToSettingsConverter<KeychainAccessProvider> keychainSettingsConverter = new ServiceToSettingsConverter<KeychainAccessProvider>(this.keychainAccessProviders);
        this.keychainBackendChoiceBox.getItems().addAll(this.keychainAccessProviders);
        this.keychainBackendChoiceBox.setValue((Object)keychainSettingsConverter.fromString((String)this.settings.keychainProvider.get()));
        this.keychainBackendChoiceBox.setConverter((StringConverter)new KeychainProviderDisplayNameConverter());
        Bindings.bindBidirectional((Property)this.settings.keychainProvider, (Property)this.keychainBackendChoiceBox.valueProperty(), keychainSettingsConverter);
        this.useKeychainCheckbox.selectedProperty().bindBidirectional((Property)this.settings.useKeychain);
        this.keychainBackendChoiceBox.disableProperty().bind((ObservableValue)this.useKeychainCheckbox.selectedProperty().not());
        this.useQuickAccessCheckbox.selectedProperty().bindBidirectional((Property)this.settings.useQuickAccess);
        ServiceToSettingsConverter<QuickAccessService> quickAccessSettingsConverter = new ServiceToSettingsConverter<QuickAccessService>(this.quickAccessServices);
        this.quickAccessServiceChoiceBox.getItems().addAll(this.quickAccessServices);
        this.quickAccessServiceChoiceBox.setValue((Object)quickAccessSettingsConverter.fromString((String)this.settings.quickAccessService.get()));
        this.quickAccessServiceChoiceBox.setConverter(new NamedServiceConverter());
        Bindings.bindBidirectional((Property)this.settings.quickAccessService, (Property)this.quickAccessServiceChoiceBox.valueProperty(), quickAccessSettingsConverter);
        this.quickAccessServiceChoiceBox.disableProperty().bind((ObservableValue)this.useQuickAccessCheckbox.selectedProperty().not());
    }

    public boolean isAutoStartSupported() {
        return this.autoStartProvider.isPresent();
    }

    @FXML
    public void toggleAutoStart() {
        this.autoStartProvider.ifPresent(autoStart -> {
            boolean enableAutoStart = this.autoStartCheckbox.isSelected();
            try {
                if (enableAutoStart) {
                    autoStart.enable();
                } else {
                    autoStart.disable();
                }
            }
            catch (ToggleAutoStartFailedException e) {
                this.autoStartCheckbox.setSelected(!enableAutoStart);
                LOG.error("Failed to toggle autostart.", (Throwable)e);
                this.appWindows.showErrorWindow(e, this.window, this.window.getScene());
            }
        });
    }

    public boolean isSomeQuickAccessServiceAvailable() {
        return !this.quickAccessServices.isEmpty();
    }

    @FXML
    public void showLogfileDirectory() {
        this.environment.getLogDir().ifPresent(logDirPath -> this.application.getHostServices().showDocument(logDirPath.toUri().toString()));
    }

    private static class ServiceToSettingsConverter<T>
    extends StringConverter<T> {
        private final List<T> services;

        public ServiceToSettingsConverter(List<T> services) {
            this.services = services;
        }

        public String toString(T service) {
            if (service == null) {
                return null;
            }
            return service.getClass().getName();
        }

        public T fromString(String string) {
            if (string == null) {
                return null;
            }
            return this.services.stream().filter(provider -> provider.getClass().getName().equals(string)).findAny().orElse(null);
        }
    }

    private static class KeychainProviderDisplayNameConverter
    extends StringConverter<KeychainAccessProvider> {
        private KeychainProviderDisplayNameConverter() {
        }

        public String toString(KeychainAccessProvider provider) {
            if (provider == null) {
                return null;
            }
            return provider.displayName();
        }

        public KeychainAccessProvider fromString(String string) {
            throw new UnsupportedOperationException();
        }
    }

    private static class NamedServiceConverter<T extends NamedServiceProvider>
    extends StringConverter<T> {
        private NamedServiceConverter() {
        }

        public String toString(T namedService) {
            if (namedService == null) {
                return null;
            }
            return namedService.getName();
        }

        public T fromString(String string) {
            throw new UnsupportedOperationException();
        }
    }
}

