/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.mainwindow;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.EnumSet;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.stream.Collectors;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.ListView;
import javafx.scene.input.ContextMenuEvent;
import javafx.scene.input.DragEvent;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.stage.Stage;
import javafx.util.Callback;
import javax.inject.Inject;
import org.apache.commons.lang3.SystemUtils;
import org.cryptomator.common.settings.Settings;
import org.cryptomator.common.vaults.Vault;
import org.cryptomator.common.vaults.VaultListManager;
import org.cryptomator.common.vaults.VaultState;
import org.cryptomator.cryptofs.CryptoFileSystemProvider;
import org.cryptomator.cryptofs.DirStructure;
import org.cryptomator.ui.addvaultwizard.AddVaultWizardComponent;
import org.cryptomator.ui.common.FxController;
import org.cryptomator.ui.common.VaultService;
import org.cryptomator.ui.dialogs.Dialogs;
import org.cryptomator.ui.fxapp.FxApplicationWindows;
import org.cryptomator.ui.mainwindow.MainWindow;
import org.cryptomator.ui.mainwindow.MainWindowScoped;
import org.cryptomator.ui.mainwindow.VaultListCellFactory;
import org.cryptomator.ui.preferences.SelectedPreferencesTab;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MainWindowScoped
public class VaultListController
implements FxController {
    private static final Logger LOG = LoggerFactory.getLogger(VaultListController.class);
    private final Stage mainWindow;
    private final ObservableList<Vault> vaults;
    private final VaultService vaultService;
    private final ObjectProperty<Vault> selectedVault;
    private final VaultListCellFactory cellFactory;
    private final AddVaultWizardComponent.Builder addVaultWizard;
    private final BooleanBinding emptyVaultList;
    private final VaultListManager vaultListManager;
    private final BooleanProperty draggingVaultOver = new SimpleBooleanProperty();
    private final ResourceBundle resourceBundle;
    private final FxApplicationWindows appWindows;
    private final ObservableValue<Double> cellSize;
    private final Dialogs dialogs;
    public ListView<Vault> vaultList;
    public StackPane root;
    @FXML
    private HBox addVaultButton;
    @FXML
    private ContextMenu addVaultContextMenu;

    @Inject
    VaultListController(@MainWindow Stage mainWindow, ObservableList<Vault> vaults, ObjectProperty<Vault> selectedVault, VaultListCellFactory cellFactory, VaultService vaultService, AddVaultWizardComponent.Builder addVaultWizard, VaultListManager vaultListManager, ResourceBundle resourceBundle, FxApplicationWindows appWindows, Settings settings, Dialogs dialogs) {
        this.mainWindow = mainWindow;
        this.vaults = vaults;
        this.selectedVault = selectedVault;
        this.cellFactory = cellFactory;
        this.vaultService = vaultService;
        this.addVaultWizard = addVaultWizard;
        this.vaultListManager = vaultListManager;
        this.resourceBundle = resourceBundle;
        this.appWindows = appWindows;
        this.dialogs = dialogs;
        this.emptyVaultList = Bindings.isEmpty(vaults);
        selectedVault.addListener(this::selectedVaultDidChange);
        this.cellSize = settings.compactMode.map(compact -> compact != false ? 30.0 : 60.0);
    }

    public void initialize() {
        this.vaultList.setItems(this.vaults);
        this.vaultList.setCellFactory((Callback)this.cellFactory);
        this.vaultList.prefHeightProperty().bind((ObservableValue)this.vaultList.fixedCellSizeProperty().multiply((ObservableNumberValue)Bindings.size((ObservableList)this.vaultList.getItems())));
        this.selectedVault.bind((ObservableValue)this.vaultList.getSelectionModel().selectedItemProperty());
        this.vaults.addListener(c -> {
            while (c.next()) {
                if (!c.wasAdded()) continue;
                Vault anyAddedVault = (Vault)c.getAddedSubList().get(0);
                this.vaultList.getSelectionModel().select((Object)anyAddedVault);
            }
        });
        this.vaultList.addEventFilter(MouseEvent.MOUSE_RELEASED, this::deselect);
        this.vaultList.addEventFilter(MouseEvent.MOUSE_CLICKED, click -> {
            if (click.getClickCount() >= 2) {
                Optional.ofNullable((Vault)this.selectedVault.get()).filter(Vault::isLocked).ifPresent(vault -> this.appWindows.startUnlockWorkflow((Vault)vault, this.mainWindow));
                Optional.ofNullable((Vault)this.selectedVault.get()).filter(Vault::isUnlocked).ifPresent(this.vaultService::reveal);
            }
        });
        this.vaultList.addEventFilter(ContextMenuEvent.CONTEXT_MENU_REQUESTED, request -> {
            if (this.selectedVault.get() == null) {
                request.consume();
            }
        });
        this.vaultList.addEventFilter(KeyEvent.KEY_PRESSED, keyEvent -> {
            if (keyEvent.getCode() == KeyCode.DELETE) {
                this.pressedShortcutToRemoveVault();
                keyEvent.consume();
            }
        });
        if (SystemUtils.IS_OS_MAC) {
            this.vaultList.addEventFilter(KeyEvent.KEY_PRESSED, keyEvent -> {
                if (keyEvent.getCode() == KeyCode.BACK_SPACE) {
                    this.pressedShortcutToRemoveVault();
                    keyEvent.consume();
                }
            });
        }
        this.mainWindow.addEventFilter(KeyEvent.KEY_RELEASED, keyEvent -> {
            if (keyEvent.isShortcutDown() && keyEvent.getCode().isDigitKey()) {
                this.vaultList.getSelectionModel().select(Integer.parseInt(keyEvent.getText()) - 1);
                keyEvent.consume();
            }
        });
        this.root.setOnDragEntered(this::handleDragEvent);
        this.root.setOnDragOver(this::handleDragEvent);
        this.root.setOnDragDropped(this::handleDragEvent);
        this.root.setOnDragExited(this::handleDragEvent);
    }

    @FXML
    private void toggleMenu() {
        if (this.addVaultContextMenu.isShowing()) {
            this.addVaultContextMenu.hide();
        } else {
            this.addVaultContextMenu.show((Node)this.addVaultButton, Side.BOTTOM, 0.0, 0.0);
        }
    }

    private void deselect(MouseEvent released) {
        if (released.getY() > (double)this.vaultList.getItems().size() * this.vaultList.fixedCellSizeProperty().get()) {
            this.vaultList.getSelectionModel().clearSelection();
            released.consume();
        }
    }

    private void selectedVaultDidChange(ObservableValue<? extends Vault> observableValue, Vault oldValue, Vault newValue) {
        if (newValue == null) {
            return;
        }
        VaultListManager.redetermineVaultState(newValue);
    }

    @FXML
    public void didClickAddNewVault() {
        this.addVaultWizard.build().showAddNewVaultWizard(this.resourceBundle);
    }

    @FXML
    public void didClickAddExistingVault() {
        this.addVaultWizard.build().showAddExistingVaultWizard(this.resourceBundle);
    }

    private void pressedShortcutToRemoveVault() {
        Vault vault = (Vault)this.selectedVault.get();
        if (vault != null && EnumSet.of(VaultState.Value.LOCKED, VaultState.Value.MISSING, VaultState.Value.ERROR, VaultState.Value.NEEDS_MIGRATION).contains((Object)vault.getState())) {
            this.dialogs.prepareRemoveVaultDialog(this.mainWindow, vault, this.vaults).build().showAndWait();
        }
    }

    private void handleDragEvent(DragEvent event) {
        if (DragEvent.DRAG_OVER.equals(event.getEventType()) && event.getGestureSource() == null && event.getDragboard().hasFiles()) {
            this.draggingVaultOver.set(event.getDragboard().getFiles().stream().map(File::toPath).anyMatch(this::containsVault));
            if (this.draggingVaultOver.get()) {
                event.acceptTransferModes(TransferMode.ANY);
            }
        } else if (DragEvent.DRAG_DROPPED.equals(event.getEventType()) && event.getGestureSource() == null && event.getDragboard().hasFiles()) {
            Set<Path> vaultPaths = event.getDragboard().getFiles().stream().map(File::toPath).filter(this::containsVault).collect(Collectors.toSet());
            if (!vaultPaths.isEmpty()) {
                vaultPaths.forEach(this::addVault);
            }
            event.setDropCompleted(!vaultPaths.isEmpty());
            event.consume();
        } else if (DragEvent.DRAG_EXITED.equals(event.getEventType())) {
            this.draggingVaultOver.set(false);
        }
    }

    private boolean containsVault(Path path) {
        try {
            if (path.getFileName().toString().endsWith(".cryptomator")) {
                path = path.getParent();
            }
            return CryptoFileSystemProvider.checkDirStructureForVault((Path)path, (String)"vault.cryptomator", (String)"masterkey.cryptomator") != DirStructure.UNRELATED;
        }
        catch (IOException e) {
            return false;
        }
    }

    private void addVault(Path pathToVault) {
        try {
            if (pathToVault.getFileName().toString().endsWith(".cryptomator")) {
                this.vaultListManager.add(pathToVault.getParent());
            } else {
                this.vaultListManager.add(pathToVault);
            }
        }
        catch (IOException e) {
            LOG.debug("Not a vault: {}", (Object)pathToVault);
        }
    }

    @FXML
    public void showPreferences() {
        this.appWindows.showPreferencesWindow(SelectedPreferencesTab.ANY);
    }

    public BooleanBinding emptyVaultListProperty() {
        return this.emptyVaultList;
    }

    public boolean isEmptyVaultList() {
        return this.emptyVaultList.get();
    }

    public BooleanProperty draggingVaultOverProperty() {
        return this.draggingVaultOver;
    }

    public boolean isDraggingVaultOver() {
        return this.draggingVaultOver.get();
    }

    public ObservableValue<Double> cellSizeProperty() {
        return this.cellSize;
    }

    public Double getCellSize() {
        return (Double)this.cellSize.getValue();
    }
}

