/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.mainwindow;

import java.util.EnumSet;
import java.util.Objects;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.stage.Stage;
import javax.inject.Inject;
import org.cryptomator.common.keychain.KeychainManager;
import org.cryptomator.common.vaults.Vault;
import org.cryptomator.common.vaults.VaultState;
import org.cryptomator.ui.common.FxController;
import org.cryptomator.ui.common.VaultService;
import org.cryptomator.ui.dialogs.Dialogs;
import org.cryptomator.ui.fxapp.FxApplicationWindows;
import org.cryptomator.ui.mainwindow.MainWindow;
import org.cryptomator.ui.mainwindow.MainWindowScoped;
import org.cryptomator.ui.vaultoptions.SelectedVaultOptionsTab;
import org.cryptomator.ui.vaultoptions.VaultOptionsComponent;

@MainWindowScoped
public class VaultListContextMenuController
implements FxController {
    private final ReadOnlyObjectProperty<Vault> selectedVault;
    private final Stage mainWindow;
    private final FxApplicationWindows appWindows;
    private final VaultService vaultService;
    private final KeychainManager keychain;
    private final VaultOptionsComponent.Factory vaultOptionsWindow;
    private final ObservableValue<VaultState.Value> selectedVaultState;
    private final ObservableValue<Boolean> selectedVaultPassphraseStored;
    private final ObservableValue<Boolean> selectedVaultRemovable;
    private final ObservableValue<Boolean> selectedVaultUnlockable;
    private final ObservableValue<Boolean> selectedVaultLockable;
    private final ObservableList<Vault> vaults;
    private final Dialogs dialogs;

    @Inject
    VaultListContextMenuController(ObjectProperty<Vault> selectedVault, ObservableList<Vault> vaults, @MainWindow Stage mainWindow, FxApplicationWindows appWindows, VaultService vaultService, KeychainManager keychain, VaultOptionsComponent.Factory vaultOptionsWindow, Dialogs dialogs) {
        this.selectedVault = selectedVault;
        this.vaults = vaults;
        this.mainWindow = mainWindow;
        this.appWindows = appWindows;
        this.vaultService = vaultService;
        this.keychain = keychain;
        this.vaultOptionsWindow = vaultOptionsWindow;
        this.dialogs = dialogs;
        this.selectedVaultState = selectedVault.flatMap(Vault::stateProperty).orElse(null);
        this.selectedVaultPassphraseStored = selectedVault.map(this::isPasswordStored).orElse((Object)false);
        this.selectedVaultRemovable = this.selectedVaultState.map(EnumSet.of(VaultState.Value.LOCKED, VaultState.Value.MISSING, VaultState.Value.ERROR, VaultState.Value.NEEDS_MIGRATION)::contains).orElse((Object)false);
        this.selectedVaultUnlockable = this.selectedVaultState.map(VaultState.Value.LOCKED::equals).orElse((Object)false);
        this.selectedVaultLockable = this.selectedVaultState.map(VaultState.Value.UNLOCKED::equals).orElse((Object)false);
    }

    private boolean isPasswordStored(Vault vault) {
        return this.keychain.getPassphraseStoredProperty(vault.getId()).get();
    }

    @FXML
    public void didClickRemoveVault() {
        Vault vault = Objects.requireNonNull((Vault)this.selectedVault.get());
        this.dialogs.prepareRemoveVaultDialog(this.mainWindow, vault, this.vaults).build().showAndWait();
    }

    @FXML
    public void didClickShowVaultOptions() {
        Vault vault = Objects.requireNonNull((Vault)this.selectedVault.get());
        this.vaultOptionsWindow.create(vault).showVaultOptionsWindow(SelectedVaultOptionsTab.ANY);
    }

    @FXML
    public void didClickUnlockVault() {
        Vault vault = Objects.requireNonNull((Vault)this.selectedVault.get());
        this.appWindows.startUnlockWorkflow(vault, this.mainWindow);
    }

    @FXML
    public void didClickLockVault() {
        Vault vault = Objects.requireNonNull((Vault)this.selectedVault.get());
        this.appWindows.startLockWorkflow(vault, this.mainWindow);
    }

    @FXML
    public void didClickRevealVault() {
        Vault vault = Objects.requireNonNull((Vault)this.selectedVault.get());
        this.vaultService.reveal(vault);
    }

    public ObservableValue<Boolean> selectedVaultUnlockableProperty() {
        return this.selectedVaultUnlockable;
    }

    public boolean isSelectedVaultUnlockable() {
        return (Boolean)this.selectedVaultUnlockable.getValue();
    }

    public ObservableValue<Boolean> selectedVaultLockableProperty() {
        return this.selectedVaultLockable;
    }

    public boolean isSelectedVaultLockable() {
        return (Boolean)this.selectedVaultLockable.getValue();
    }

    public ObservableValue<Boolean> selectedVaultRemovableProperty() {
        return this.selectedVaultRemovable;
    }

    public boolean isSelectedVaultRemovable() {
        return (Boolean)this.selectedVaultRemovable.getValue();
    }

    public ObservableValue<Boolean> selectedVaultPassphraseStoredProperty() {
        return this.selectedVaultPassphraseStored;
    }

    public boolean isSelectedVaultPassphraseStored() {
        return (Boolean)this.selectedVaultPassphraseStored.getValue();
    }
}

