/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.mainwindow;

import javafx.beans.Observable;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.fxml.FXML;
import javafx.scene.layout.StackPane;
import javafx.stage.Stage;
import javax.inject.Inject;
import org.apache.commons.lang3.SystemUtils;
import org.cryptomator.common.LicenseHolder;
import org.cryptomator.common.settings.Settings;
import org.cryptomator.common.vaults.Vault;
import org.cryptomator.common.vaults.VaultListManager;
import org.cryptomator.ui.common.FxController;
import org.cryptomator.ui.fxapp.FxApplicationWindows;
import org.cryptomator.ui.fxapp.UpdateChecker;
import org.cryptomator.ui.mainwindow.MainWindow;
import org.cryptomator.ui.mainwindow.MainWindowScoped;
import org.cryptomator.ui.preferences.SelectedPreferencesTab;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MainWindowScoped
public class MainWindowController
implements FxController {
    private static final Logger LOG = LoggerFactory.getLogger(MainWindowController.class);
    private final Stage window;
    private final ReadOnlyObjectProperty<Vault> selectedVault;
    private final Settings settings;
    private final FxApplicationWindows appWindows;
    private final BooleanBinding updateAvailable;
    private final LicenseHolder licenseHolder;
    @FXML
    private StackPane root;

    @Inject
    public MainWindowController(@MainWindow Stage window, ObjectProperty<Vault> selectedVault, Settings settings, FxApplicationWindows appWindows, UpdateChecker updateChecker, LicenseHolder licenseHolder) {
        this.window = window;
        this.selectedVault = selectedVault;
        this.settings = settings;
        this.appWindows = appWindows;
        this.updateAvailable = updateChecker.updateAvailableProperty();
        this.licenseHolder = licenseHolder;
        updateChecker.automaticallyCheckForUpdatesIfEnabled();
    }

    @FXML
    public void initialize() {
        LOG.trace("init MainWindowController");
        if (SystemUtils.IS_OS_WINDOWS) {
            this.root.getStyleClass().add((Object)"os-windows");
        }
        this.window.focusedProperty().addListener(this::mainWindowFocusChanged);
        if (!this.neverTouched()) {
            this.window.setHeight((double)this.settings.windowHeight.get() > this.window.getMinHeight() ? (double)this.settings.windowHeight.get() : this.window.getMinHeight());
            this.window.setWidth((double)this.settings.windowWidth.get() > this.window.getMinWidth() ? (double)this.settings.windowWidth.get() : this.window.getMinWidth());
            this.window.setX((double)this.settings.windowXPosition.get());
            this.window.setY((double)this.settings.windowYPosition.get());
        }
        this.window.widthProperty().addListener((observableValue, number, number2) -> this.savePositionalSettings());
        this.window.heightProperty().addListener((observableValue, number, number2) -> this.savePositionalSettings());
        this.window.xProperty().addListener((observableValue, number, number2) -> this.savePositionalSettings());
        this.window.yProperty().addListener((observableValue, number, number2) -> this.savePositionalSettings());
    }

    private boolean neverTouched() {
        return this.settings.windowHeight.get() == 0 && this.settings.windowWidth.get() == 0 && this.settings.windowXPosition.get() == 0 && this.settings.windowYPosition.get() == 0;
    }

    public void savePositionalSettings() {
        this.settings.windowWidth.setValue((Number)this.window.getWidth());
        this.settings.windowHeight.setValue((Number)this.window.getHeight());
        this.settings.windowXPosition.setValue((Number)this.window.getX());
        this.settings.windowYPosition.setValue((Number)this.window.getY());
    }

    private void mainWindowFocusChanged(Observable observable) {
        Vault v = (Vault)this.selectedVault.get();
        if (v != null) {
            VaultListManager.redetermineVaultState(v);
        }
    }

    @FXML
    public void showGeneralPreferences() {
        this.appWindows.showPreferencesWindow(SelectedPreferencesTab.GENERAL);
    }

    @FXML
    public void showContributePreferences() {
        this.appWindows.showPreferencesWindow(SelectedPreferencesTab.CONTRIBUTE);
    }

    @FXML
    public void showUpdatePreferences() {
        this.appWindows.showPreferencesWindow(SelectedPreferencesTab.UPDATES);
    }

    public ReadOnlyBooleanProperty debugModeEnabledProperty() {
        return this.settings.debugMode;
    }

    public boolean getDebugModeEnabled() {
        return this.debugModeEnabledProperty().get();
    }

    public BooleanBinding updateAvailableProperty() {
        return this.updateAvailable;
    }

    public boolean getUpdateAvailable() {
        return this.updateAvailable.get();
    }

    public BooleanBinding licenseValidProperty() {
        return this.licenseHolder.validLicenseProperty();
    }

    public boolean getLicenseValid() {
        return this.licenseHolder.isValidLicense();
    }
}

