/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.keyloading.hub;

import java.util.concurrent.CompletableFuture;
import javafx.application.Application;
import javafx.fxml.FXML;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;
import javax.inject.Inject;
import org.cryptomator.ui.common.FxController;
import org.cryptomator.ui.keyloading.KeyLoading;
import org.cryptomator.ui.keyloading.KeyLoadingScoped;
import org.cryptomator.ui.keyloading.hub.HubConfig;
import org.cryptomator.ui.keyloading.hub.ReceivedKey;

@KeyLoadingScoped
public class RequireAccountInitController
implements FxController {
    private final Application application;
    private final HubConfig hubConfig;
    private final Stage window;
    private final CompletableFuture<ReceivedKey> result;

    @Inject
    public RequireAccountInitController(Application application, HubConfig hubConfig, @KeyLoading Stage window, CompletableFuture<ReceivedKey> result) {
        this.application = application;
        this.hubConfig = hubConfig;
        this.window = window;
        this.result = result;
        this.window.addEventHandler(WindowEvent.WINDOW_HIDING, this::windowClosed);
    }

    @FXML
    public void completeSetup() {
        this.application.getHostServices().showDocument(this.hubConfig.getWebappBaseUrl().resolve("profile").toString());
        this.close();
    }

    @FXML
    public void close() {
        this.window.close();
    }

    private void windowClosed(WindowEvent windowEvent) {
        this.result.cancel(true);
    }
}

