/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.health;

import dagger.Binds;
import dagger.Module;
import dagger.Provides;
import dagger.multibindings.IntoMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.concurrent.atomic.AtomicReference;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.scene.Scene;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javax.inject.Named;
import javax.inject.Provider;
import org.cryptomator.common.vaults.Vault;
import org.cryptomator.cryptofs.VaultConfig;
import org.cryptomator.cryptofs.health.api.HealthCheck;
import org.cryptomator.cryptolib.api.Masterkey;
import org.cryptomator.cryptolib.common.DestroyableSecretKey;
import org.cryptomator.ui.common.DefaultSceneFactory;
import org.cryptomator.ui.common.FxController;
import org.cryptomator.ui.common.FxControllerKey;
import org.cryptomator.ui.common.FxmlFile;
import org.cryptomator.ui.common.FxmlLoaderFactory;
import org.cryptomator.ui.common.FxmlScene;
import org.cryptomator.ui.common.StageFactory;
import org.cryptomator.ui.health.Check;
import org.cryptomator.ui.health.CheckDetailController;
import org.cryptomator.ui.health.CheckListCellController;
import org.cryptomator.ui.health.CheckListController;
import org.cryptomator.ui.health.HealthCheckScoped;
import org.cryptomator.ui.health.HealthCheckWindow;
import org.cryptomator.ui.health.ResultListCellController;
import org.cryptomator.ui.health.StartController;
import org.cryptomator.ui.keyloading.KeyLoadingComponent;
import org.cryptomator.ui.keyloading.KeyLoadingStrategy;

@Module(subcomponents={KeyLoadingComponent.class})
abstract class HealthCheckModule {
    HealthCheckModule() {
    }

    @Provides
    @HealthCheckScoped
    static AtomicReference<Masterkey> provideMasterkeyRef() {
        return new AtomicReference<Masterkey>();
    }

    @Provides
    @HealthCheckScoped
    static AtomicReference<VaultConfig> provideVaultConfigRef() {
        return new AtomicReference<VaultConfig>();
    }

    @Provides
    @HealthCheckScoped
    static ObjectProperty<Check> provideSelectedCheck() {
        return new SimpleObjectProperty();
    }

    @Provides
    @HealthCheckScoped
    static List<Check> provideAvailableChecks() {
        return HealthCheck.allChecks().stream().map(Check::new).toList();
    }

    @Provides
    @HealthCheckWindow
    @HealthCheckScoped
    static KeyLoadingStrategy provideKeyLoadingStrategy(KeyLoadingComponent.Builder compBuilder, @HealthCheckWindow Vault vault, @Named(value="unlockWindow") Stage window) {
        return compBuilder.vault(vault).window(window).build().keyloadingStrategy();
    }

    @Provides
    @HealthCheckWindow
    @HealthCheckScoped
    static FxmlLoaderFactory provideFxmlLoaderFactory(Map<Class<? extends FxController>, Provider<FxController>> factories, DefaultSceneFactory sceneFactory, ResourceBundle resourceBundle) {
        return new FxmlLoaderFactory(factories, sceneFactory, resourceBundle);
    }

    @Provides
    @Named(value="unlockWindow")
    @HealthCheckScoped
    static Stage provideUnlockWindow(@HealthCheckWindow Stage window, @HealthCheckWindow Vault vault, StageFactory factory, ResourceBundle resourceBundle) {
        Stage stage = factory.create();
        stage.initModality(Modality.WINDOW_MODAL);
        stage.initOwner((Window)window);
        stage.setTitle(String.format(resourceBundle.getString("unlock.title"), vault.getDisplayName()));
        stage.setResizable(false);
        return stage;
    }

    @Provides
    @HealthCheckWindow
    @HealthCheckScoped
    static Stage provideStage(StageFactory factory, @Named(value="healthCheckOwner") Stage owner, @HealthCheckWindow Vault vault, ChangeListener<Boolean> showingListener, ResourceBundle resourceBundle) {
        Stage stage = factory.create();
        stage.initModality(Modality.WINDOW_MODAL);
        stage.initOwner((Window)owner);
        stage.setTitle(String.format(resourceBundle.getString("health.title"), vault.getDisplayName()));
        stage.setResizable(true);
        stage.showingProperty().addListener(showingListener);
        return stage;
    }

    @Provides
    @HealthCheckScoped
    static ChangeListener<Boolean> provideWindowShowingChangeListener(AtomicReference<Masterkey> masterkey) {
        return (observable, wasShowing, isShowing) -> {
            if (!isShowing.booleanValue()) {
                Optional.ofNullable(masterkey.getAndSet(null)).ifPresent(DestroyableSecretKey::destroy);
            }
        };
    }

    @Provides
    @FxmlScene(value=FxmlFile.HEALTH_START)
    @HealthCheckScoped
    static Scene provideHealthStartScene(@HealthCheckWindow FxmlLoaderFactory fxmlLoaders) {
        return fxmlLoaders.createScene(FxmlFile.HEALTH_START);
    }

    @Provides
    @FxmlScene(value=FxmlFile.HEALTH_CHECK_LIST)
    @HealthCheckScoped
    static Scene provideHealthCheckListScene(@HealthCheckWindow FxmlLoaderFactory fxmlLoaders) {
        return fxmlLoaders.createScene(FxmlFile.HEALTH_CHECK_LIST);
    }

    @Binds
    @IntoMap
    @FxControllerKey(value=StartController.class)
    abstract FxController bindStartController(StartController var1);

    @Binds
    @IntoMap
    @FxControllerKey(value=CheckListController.class)
    abstract FxController bindCheckController(CheckListController var1);

    @Binds
    @IntoMap
    @FxControllerKey(value=CheckDetailController.class)
    abstract FxController bindCheckDetailController(CheckDetailController var1);

    @Binds
    @IntoMap
    @FxControllerKey(value=ResultListCellController.class)
    abstract FxController bindResultListCellController(ResultListCellController var1);

    @Binds
    @IntoMap
    @FxControllerKey(value=CheckListCellController.class)
    abstract FxController bindCheckListCellController(CheckListCellController var1);
}

