/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.fxapp;

import dagger.Module;
import dagger.Provides;
import java.io.IOException;
import java.io.InputStream;
import javafx.scene.image.Image;
import org.cryptomator.ui.error.ErrorComponent;
import org.cryptomator.ui.fxapp.FxApplicationScoped;
import org.cryptomator.ui.fxapp.UpdateCheckerModule;
import org.cryptomator.ui.health.HealthCheckComponent;
import org.cryptomator.ui.lock.LockComponent;
import org.cryptomator.ui.mainwindow.MainWindowComponent;
import org.cryptomator.ui.preferences.PreferencesComponent;
import org.cryptomator.ui.quit.QuitComponent;
import org.cryptomator.ui.sharevault.ShareVaultComponent;
import org.cryptomator.ui.traymenu.TrayMenuComponent;
import org.cryptomator.ui.unlock.UnlockComponent;
import org.cryptomator.ui.updatereminder.UpdateReminderComponent;
import org.cryptomator.ui.vaultoptions.VaultOptionsComponent;

@Module(includes={UpdateCheckerModule.class}, subcomponents={TrayMenuComponent.class, MainWindowComponent.class, PreferencesComponent.class, VaultOptionsComponent.class, UnlockComponent.class, LockComponent.class, QuitComponent.class, ErrorComponent.class, HealthCheckComponent.class, UpdateReminderComponent.class, ShareVaultComponent.class})
abstract class FxApplicationModule {
    FxApplicationModule() {
    }

    private static Image createImageFromResource(String resourceName) throws IOException {
        try (InputStream in = FxApplicationModule.class.getResourceAsStream(resourceName);){
            Image image = new Image(in);
            return image;
        }
    }

    @Provides
    @FxApplicationScoped
    static TrayMenuComponent provideTrayMenuComponent(TrayMenuComponent.Builder builder) {
        return builder.build();
    }

    @Provides
    @FxApplicationScoped
    static MainWindowComponent provideMainWindowComponent(MainWindowComponent.Builder builder) {
        return builder.build();
    }

    @Provides
    @FxApplicationScoped
    static PreferencesComponent providePreferencesComponent(PreferencesComponent.Builder builder) {
        return builder.build();
    }

    @Provides
    @FxApplicationScoped
    static QuitComponent provideQuitComponent(QuitComponent.Builder builder) {
        return builder.build();
    }
}

