/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.addvaultwizard;

import dagger.Lazy;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javafx.application.Platform;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.stage.DirectoryChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import javax.inject.Inject;
import javax.inject.Named;
import org.cryptomator.common.ObservableUtil;
import org.cryptomator.common.locationpresets.LocationPreset;
import org.cryptomator.common.locationpresets.LocationPresetsProvider;
import org.cryptomator.ui.addvaultwizard.AddVaultWizardScoped;
import org.cryptomator.ui.addvaultwizard.AddVaultWizardWindow;
import org.cryptomator.ui.common.FxController;
import org.cryptomator.ui.common.FxmlFile;
import org.cryptomator.ui.common.FxmlScene;
import org.cryptomator.ui.controls.FontAwesome5IconView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AddVaultWizardScoped
public class CreateNewVaultLocationController
implements FxController {
    private static final Logger LOG = LoggerFactory.getLogger(CreateNewVaultLocationController.class);
    private static final Path DEFAULT_CUSTOM_VAULT_PATH = Paths.get(System.getProperty("user.home"), new String[0]);
    private static final String TEMP_FILE_PREFIX = ".locationTest.cryptomator";
    private final Stage window;
    private final Lazy<Scene> chooseNameScene;
    private final Lazy<Scene> chooseExpertSettingsScene;
    private final ObjectProperty<Path> vaultPath;
    private final StringProperty vaultName;
    private final ExecutorService backgroundExecutor;
    private final ResourceBundle resourceBundle;
    private final ObservableValue<VaultPathStatus> vaultPathStatus;
    private final ObservableValue<Boolean> validVaultPath;
    private final BooleanProperty usePresetPath;
    private final BooleanProperty loadingPresetLocations = new SimpleBooleanProperty(false);
    private final ObservableList<Node> radioButtons;
    private final ObservableList<Node> sortedRadioButtons;
    private Path customVaultPath = DEFAULT_CUSTOM_VAULT_PATH;
    public ToggleGroup locationPresetsToggler;
    public VBox radioButtonVBox;
    public HBox customLocationRadioBtn;
    public RadioButton customRadioButton;
    public Label locationStatusLabel;
    public FontAwesome5IconView goodLocation;
    public FontAwesome5IconView badLocation;

    @Inject
    CreateNewVaultLocationController(@AddVaultWizardWindow Stage window, @FxmlScene(value=FxmlFile.ADDVAULT_NEW_NAME) Lazy<Scene> chooseNameScene, @FxmlScene(value=FxmlFile.ADDVAULT_NEW_EXPERT_SETTINGS) Lazy<Scene> chooseExpertSettingsScene, ObjectProperty<Path> vaultPath, @Named(value="vaultName") StringProperty vaultName, ExecutorService backgroundExecutor, ResourceBundle resourceBundle) {
        this.window = window;
        this.chooseNameScene = chooseNameScene;
        this.chooseExpertSettingsScene = chooseExpertSettingsScene;
        this.vaultPath = vaultPath;
        this.vaultName = vaultName;
        this.backgroundExecutor = backgroundExecutor;
        this.resourceBundle = resourceBundle;
        this.vaultPathStatus = ObservableUtil.mapWithDefault(vaultPath, this::validatePath, new VaultPathStatus(false, "error.message"));
        this.validVaultPath = ObservableUtil.mapWithDefault(this.vaultPathStatus, VaultPathStatus::valid, false);
        this.vaultPathStatus.addListener(this::updateStatusLabel);
        this.usePresetPath = new SimpleBooleanProperty();
        this.radioButtons = FXCollections.observableArrayList();
        this.sortedRadioButtons = this.radioButtons.sorted(this::compareLocationPresets);
    }

    private VaultPathStatus validatePath(Path p) throws NullPointerException {
        if (!Files.exists(p.getParent(), new LinkOption[0])) {
            return new VaultPathStatus(false, "addvaultwizard.new.locationDoesNotExist");
        }
        if (!this.isActuallyWritable(p.getParent())) {
            return new VaultPathStatus(false, "addvaultwizard.new.locationIsNotWritable");
        }
        if (!Files.notExists(p, new LinkOption[0])) {
            return new VaultPathStatus(false, "addvaultwizard.new.fileAlreadyExists");
        }
        return new VaultPathStatus(true, "addvaultwizard.new.locationIsOk");
    }

    private void updateStatusLabel(ObservableValue<? extends VaultPathStatus> observable, VaultPathStatus oldValue, VaultPathStatus newValue) {
        if (newValue.valid()) {
            this.locationStatusLabel.setGraphic((Node)this.goodLocation);
            this.locationStatusLabel.getStyleClass().remove((Object)"label-red");
            this.locationStatusLabel.getStyleClass().add((Object)"label-muted");
        } else {
            this.locationStatusLabel.setGraphic((Node)this.badLocation);
            this.locationStatusLabel.getStyleClass().remove((Object)"label-muted");
            this.locationStatusLabel.getStyleClass().add((Object)"label-red");
        }
        this.locationStatusLabel.setText(this.resourceBundle.getString(newValue.localizationKey()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isActuallyWritable(Path p) {
        Path tmpDir = null;
        try {
            tmpDir = Files.createTempDirectory(p, TEMP_FILE_PREFIX, new FileAttribute[0]);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (tmpDir != null) {
                try {
                    Files.deleteIfExists(tmpDir);
                }
                catch (IOException e) {
                    LOG.warn("Unable to delete temporary directory {}. Needs to be deleted manually.", (Object)tmpDir);
                }
            }
        }
    }

    @FXML
    public void initialize() {
        Future<?> task = this.backgroundExecutor.submit(this::loadLocationPresets);
        this.window.addEventHandler(WindowEvent.WINDOW_HIDING, windowEvent -> task.cancel(true));
        this.locationPresetsToggler.selectedToggleProperty().addListener(this::togglePredefinedLocation);
        this.usePresetPath.bind((ObservableValue)this.locationPresetsToggler.selectedToggleProperty().isNotEqualTo((Object)this.customRadioButton));
        this.radioButtons.add((Object)this.customLocationRadioBtn);
        Bindings.bindContent((List)this.radioButtonVBox.getChildren(), this.sortedRadioButtons);
    }

    private void loadLocationPresets() {
        Platform.runLater(() -> this.loadingPresetLocations.set(true));
        try {
            LocationPresetsProvider.loadAll(LocationPresetsProvider.class).flatMap(LocationPresetsProvider::getLocations).forEach(this::createRadioButtonFor);
        }
        finally {
            Platform.runLater(() -> this.loadingPresetLocations.set(false));
        }
    }

    private void createRadioButtonFor(LocationPreset preset) {
        Platform.runLater(() -> {
            RadioButton btn = new RadioButton(preset.name());
            btn.setUserData((Object)preset.path());
            this.radioButtons.add((Object)btn);
            this.locationPresetsToggler.getToggles().add((Object)btn);
        });
    }

    private int compareLocationPresets(Node left, Node right) {
        if (this.customLocationRadioBtn.getId().equals(left.getId())) {
            return 1;
        }
        if (this.customLocationRadioBtn.getId().equals(right.getId())) {
            return -1;
        }
        return ((RadioButton)left).getText().compareToIgnoreCase(((RadioButton)right).getText());
    }

    private void togglePredefinedLocation(ObservableValue<? extends Toggle> observable, Toggle oldValue, Toggle newValue) {
        Path storagePath = Optional.ofNullable((Path)newValue.getUserData()).orElse(this.customVaultPath);
        this.vaultPath.set((Object)storagePath.resolve((String)this.vaultName.get()));
    }

    @FXML
    public void back() {
        this.window.setScene((Scene)this.chooseNameScene.get());
    }

    @FXML
    public void next() {
        if (((Boolean)this.validVaultPath.getValue()).booleanValue()) {
            this.window.setScene((Scene)this.chooseExpertSettingsScene.get());
        }
    }

    @FXML
    public void chooseCustomVaultPath() {
        DirectoryChooser directoryChooser = new DirectoryChooser();
        directoryChooser.setTitle(this.resourceBundle.getString("addvaultwizard.new.directoryPickerTitle"));
        if (Files.exists(this.customVaultPath, new LinkOption[0])) {
            directoryChooser.setInitialDirectory(this.customVaultPath.toFile());
        } else {
            directoryChooser.setInitialDirectory(DEFAULT_CUSTOM_VAULT_PATH.toFile());
        }
        File file = directoryChooser.showDialog((Window)this.window);
        if (file != null) {
            this.customVaultPath = file.toPath().toAbsolutePath();
            this.vaultPath.set((Object)this.customVaultPath.resolve((String)this.vaultName.get()));
        }
    }

    public Path getVaultPath() {
        return (Path)this.vaultPath.get();
    }

    public ObjectProperty<Path> vaultPathProperty() {
        return this.vaultPath;
    }

    public ObservableValue<Boolean> validVaultPathProperty() {
        return this.validVaultPath;
    }

    public boolean isValidVaultPath() {
        return Boolean.TRUE.equals(this.validVaultPath.getValue());
    }

    public boolean isLoadingPresetLocations() {
        return this.loadingPresetLocations.getValue();
    }

    public BooleanProperty loadingPresetLocationsProperty() {
        return this.loadingPresetLocations;
    }

    public BooleanProperty usePresetPathProperty() {
        return this.usePresetPath;
    }

    public boolean isUsePresetPath() {
        return this.usePresetPath.get();
    }

    public BooleanBinding anyRadioButtonSelectedProperty() {
        return this.locationPresetsToggler.selectedToggleProperty().isNotNull();
    }

    public boolean isAnyRadioButtonSelected() {
        return this.anyRadioButtonSelectedProperty().get();
    }

    private record VaultPathStatus(boolean valid, String localizationKey) {
    }
}

