/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ipc;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.cryptomator.ipc.IpcMessage;

record HandleLaunchArgsMessage(List<String> args) implements IpcMessage
{
    private static final char DELIMITER = '\n';

    public static HandleLaunchArgsMessage decode(ByteBuffer encoded) {
        String str = StandardCharsets.UTF_8.decode(encoded).toString();
        List args = Splitter.on((char)'\n').omitEmptyStrings().splitToList((CharSequence)str);
        return new HandleLaunchArgsMessage(args);
    }

    @Override
    public IpcMessage.MessageType getMessageType() {
        return IpcMessage.MessageType.HANDLE_LAUNCH_ARGS;
    }

    @Override
    public ByteBuffer encodePayload() {
        String str = Joiner.on((char)'\n').join(this.args);
        return StandardCharsets.UTF_8.encode(str);
    }
}

