/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.common.settings;

import java.time.Instant;
import java.util.function.Consumer;
import javafx.beans.Observable;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.NodeOrientation;
import org.apache.commons.lang3.SystemUtils;
import org.cryptomator.common.Environment;
import org.cryptomator.common.settings.SettingsJson;
import org.cryptomator.common.settings.UiTheme;
import org.cryptomator.common.settings.VaultSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Settings {
    private static final Logger LOG = LoggerFactory.getLogger(Settings.class);
    static final boolean DEFAULT_CHECK_FOR_UPDATES = false;
    static final boolean DEFAULT_START_HIDDEN = false;
    static final boolean DEFAULT_AUTO_CLOSE_VAULTS = false;
    static final boolean DEFAULT_USE_KEYCHAIN = true;
    static final boolean DEFAULT_USE_QUICKACCESS = true;
    static final int DEFAULT_PORT = 42427;
    static final int DEFAULT_NUM_TRAY_NOTIFICATIONS = 3;
    static final boolean DEFAULT_DEBUG_MODE = false;
    static final UiTheme DEFAULT_THEME = UiTheme.LIGHT;
    @Deprecated
    static final String DEFAULT_KEYCHAIN_PROVIDER;
    static final String DEFAULT_QUICKACCESS_SERVICE;
    static final String DEFAULT_USER_INTERFACE_ORIENTATION;
    public static final Instant DEFAULT_TIMESTAMP;
    public final ObservableList<VaultSettings> directories = FXCollections.observableArrayList(VaultSettings::observables);
    public final BooleanProperty startHidden;
    public final BooleanProperty autoCloseVaults;
    public final BooleanProperty useKeychain;
    public final IntegerProperty port;
    public final IntegerProperty numTrayNotifications;
    public final BooleanProperty debugMode;
    public final ObjectProperty<UiTheme> theme;
    public final StringProperty keychainProvider;
    public final BooleanProperty useQuickAccess;
    public final StringProperty quickAccessService;
    public final ObjectProperty<NodeOrientation> userInterfaceOrientation;
    public final StringProperty licenseKey;
    public final BooleanProperty showTrayIcon;
    public final BooleanProperty compactMode;
    public final IntegerProperty windowXPosition;
    public final IntegerProperty windowYPosition;
    public final IntegerProperty windowWidth;
    public final IntegerProperty windowHeight;
    public final StringProperty language;
    public final StringProperty mountService;
    public final BooleanProperty checkForUpdates;
    public final ObjectProperty<Instant> lastUpdateCheckReminder;
    public final ObjectProperty<Instant> lastSuccessfulUpdateCheck;
    private Consumer<Settings> saveCmd;

    public static Settings create(Environment env) {
        SettingsJson defaults = new SettingsJson();
        defaults.showTrayIcon = env.showTrayIcon();
        return new Settings(defaults);
    }

    Settings(SettingsJson json) {
        this.startHidden = new SimpleBooleanProperty((Object)this, "startHidden", json.startHidden);
        this.autoCloseVaults = new SimpleBooleanProperty((Object)this, "autoCloseVaults", json.autoCloseVaults);
        this.useKeychain = new SimpleBooleanProperty((Object)this, "useKeychain", json.useKeychain);
        this.useQuickAccess = new SimpleBooleanProperty((Object)this, "addToQuickAccess", json.useQuickAccess);
        this.port = new SimpleIntegerProperty((Object)this, "webDavPort", json.port);
        this.numTrayNotifications = new SimpleIntegerProperty((Object)this, "numTrayNotifications", json.numTrayNotifications);
        this.debugMode = new SimpleBooleanProperty((Object)this, "debugMode", json.debugMode);
        this.theme = new SimpleObjectProperty((Object)this, "theme", (Object)json.theme);
        this.keychainProvider = new SimpleStringProperty((Object)this, "keychainProvider", json.keychainProvider);
        this.userInterfaceOrientation = new SimpleObjectProperty((Object)this, "userInterfaceOrientation", (Object)this.parseEnum(json.uiOrientation, NodeOrientation.class, NodeOrientation.LEFT_TO_RIGHT));
        this.licenseKey = new SimpleStringProperty((Object)this, "licenseKey", json.licenseKey);
        this.showTrayIcon = new SimpleBooleanProperty((Object)this, "showTrayIcon", json.showTrayIcon);
        this.compactMode = new SimpleBooleanProperty((Object)this, "compactMode", json.compactMode);
        this.windowXPosition = new SimpleIntegerProperty((Object)this, "windowXPosition", json.windowXPosition);
        this.windowYPosition = new SimpleIntegerProperty((Object)this, "windowYPosition", json.windowYPosition);
        this.windowWidth = new SimpleIntegerProperty((Object)this, "windowWidth", json.windowWidth);
        this.windowHeight = new SimpleIntegerProperty((Object)this, "windowHeight", json.windowHeight);
        this.language = new SimpleStringProperty((Object)this, "language", json.language);
        this.mountService = new SimpleStringProperty((Object)this, "mountService", json.mountService);
        this.quickAccessService = new SimpleStringProperty((Object)this, "quickAccessService", json.quickAccessService);
        this.checkForUpdates = new SimpleBooleanProperty((Object)this, "checkForUpdates", json.checkForUpdatesEnabled);
        this.lastUpdateCheckReminder = new SimpleObjectProperty((Object)this, "lastUpdateCheckReminder", (Object)json.lastReminderForUpdateCheck);
        this.lastSuccessfulUpdateCheck = new SimpleObjectProperty((Object)this, "lastSuccessfulUpdateCheck", (Object)json.lastSuccessfulUpdateCheck);
        this.directories.addAll(json.directories.stream().map(VaultSettings::new).toList());
        this.migrateLegacySettings(json);
        this.directories.addListener(this::somethingChanged);
        this.startHidden.addListener(this::somethingChanged);
        this.autoCloseVaults.addListener(this::somethingChanged);
        this.useKeychain.addListener(this::somethingChanged);
        this.useQuickAccess.addListener(this::somethingChanged);
        this.port.addListener(this::somethingChanged);
        this.numTrayNotifications.addListener(this::somethingChanged);
        this.debugMode.addListener(this::somethingChanged);
        this.theme.addListener(this::somethingChanged);
        this.keychainProvider.addListener(this::somethingChanged);
        this.userInterfaceOrientation.addListener(this::somethingChanged);
        this.licenseKey.addListener(this::somethingChanged);
        this.showTrayIcon.addListener(this::somethingChanged);
        this.compactMode.addListener(this::somethingChanged);
        this.windowXPosition.addListener(this::somethingChanged);
        this.windowYPosition.addListener(this::somethingChanged);
        this.windowWidth.addListener(this::somethingChanged);
        this.windowHeight.addListener(this::somethingChanged);
        this.language.addListener(this::somethingChanged);
        this.mountService.addListener(this::somethingChanged);
        this.quickAccessService.addListener(this::somethingChanged);
        this.checkForUpdates.addListener(this::somethingChanged);
        this.lastUpdateCheckReminder.addListener(this::somethingChanged);
        this.lastSuccessfulUpdateCheck.addListener(this::somethingChanged);
    }

    private void migrateLegacySettings(SettingsJson json) {
        if (this.mountService.get() == null && json.preferredVolumeImpl != null) {
            this.mountService.set((Object)(switch (json.preferredVolumeImpl) {
                case "Dokany" -> "org.cryptomator.frontend.dokany.mount.DokanyMountProvider";
                case "FUSE" -> {
                    if (SystemUtils.IS_OS_WINDOWS) {
                        yield "org.cryptomator.frontend.fuse.mount.WinFspNetworkMountProvider";
                    }
                    if (SystemUtils.IS_OS_MAC) {
                        yield "org.cryptomator.frontend.fuse.mount.MacFuseMountProvider";
                    }
                    yield "org.cryptomator.frontend.fuse.mount.LinuxFuseMountProvider";
                }
                default -> SystemUtils.IS_OS_WINDOWS ? "org.cryptomator.frontend.webdav.mount.WindowsMounter" : (SystemUtils.IS_OS_MAC ? "org.cryptomator.frontend.webdav.mount.MacAppleScriptMounter" : "org.cryptomator.frontend.webdav.mount.LinuxGioMounter");
            }));
        }
    }

    SettingsJson serialized() {
        SettingsJson json = new SettingsJson();
        json.directories = this.directories.stream().map(VaultSettings::serialized).toList();
        json.startHidden = this.startHidden.get();
        json.autoCloseVaults = this.autoCloseVaults.get();
        json.useKeychain = this.useKeychain.get();
        json.useQuickAccess = this.useQuickAccess.get();
        json.port = this.port.get();
        json.numTrayNotifications = this.numTrayNotifications.get();
        json.debugMode = this.debugMode.get();
        json.theme = (UiTheme)((Object)this.theme.get());
        json.keychainProvider = (String)this.keychainProvider.get();
        json.uiOrientation = ((NodeOrientation)this.userInterfaceOrientation.get()).name();
        json.licenseKey = (String)this.licenseKey.get();
        json.showTrayIcon = this.showTrayIcon.get();
        json.compactMode = this.compactMode.get();
        json.windowXPosition = this.windowXPosition.get();
        json.windowYPosition = this.windowYPosition.get();
        json.windowWidth = this.windowWidth.get();
        json.windowHeight = this.windowHeight.get();
        json.language = (String)this.language.get();
        json.mountService = (String)this.mountService.get();
        json.quickAccessService = (String)this.quickAccessService.get();
        json.checkForUpdatesEnabled = this.checkForUpdates.get();
        json.lastReminderForUpdateCheck = (Instant)this.lastUpdateCheckReminder.get();
        json.lastSuccessfulUpdateCheck = (Instant)this.lastSuccessfulUpdateCheck.get();
        return json;
    }

    private <E extends Enum<E>> E parseEnum(String value, Class<E> clazz, E defaultValue) {
        try {
            return Enum.valueOf(clazz, value.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            LOG.warn("No value {}.{}. Defaulting to {}.", new Object[]{clazz.getSimpleName(), value, defaultValue});
            return defaultValue;
        }
    }

    void setSaveCmd(Consumer<Settings> saveCmd) {
        this.saveCmd = saveCmd;
    }

    private void somethingChanged(Observable observable) {
        this.save();
    }

    void save() {
        if (this.saveCmd != null) {
            this.saveCmd.accept(this);
        }
    }

    static {
        String string = SystemUtils.IS_OS_WINDOWS ? "org.cryptomator.windows.keychain.WindowsProtectedKeychainAccess" : (DEFAULT_KEYCHAIN_PROVIDER = SystemUtils.IS_OS_MAC ? "org.cryptomator.macos.keychain.MacSystemKeychainAccess" : "org.cryptomator.linux.keychain.SecretServiceKeychainAccess");
        DEFAULT_QUICKACCESS_SERVICE = SystemUtils.IS_OS_WINDOWS ? "org.cryptomator.windows.quickaccess.ExplorerQuickAccessService" : (SystemUtils.IS_OS_LINUX ? "org.cryptomator.linux.quickaccess.NautilusBookmarks" : null);
        DEFAULT_USER_INTERFACE_ORIENTATION = NodeOrientation.LEFT_TO_RIGHT.name();
        DEFAULT_TIMESTAMP = Instant.parse("2000-01-01T00:00:00Z");
    }
}

