/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.common.keychain;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.util.Arrays;
import javafx.application.Platform;
import javafx.beans.binding.ObjectExpression;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.cryptomator.common.keychain.NoKeychainAccessProviderException;
import org.cryptomator.integrations.keychain.KeychainAccessException;
import org.cryptomator.integrations.keychain.KeychainAccessProvider;

@Singleton
public class KeychainManager
implements KeychainAccessProvider {
    private final ObjectExpression<KeychainAccessProvider> keychain;
    private final LoadingCache<String, BooleanProperty> passphraseStoredProperties;

    @Inject
    KeychainManager(ObjectExpression<KeychainAccessProvider> selectedKeychain) {
        this.keychain = selectedKeychain;
        this.passphraseStoredProperties = Caffeine.newBuilder().weakValues().build(this::createStoredPassphraseProperty);
        this.keychain.addListener(ignored -> this.passphraseStoredProperties.invalidateAll());
    }

    private KeychainAccessProvider getKeychainOrFail() throws KeychainAccessException {
        KeychainAccessProvider result = (KeychainAccessProvider)this.keychain.getValue();
        if (result == null) {
            throw new NoKeychainAccessProviderException();
        }
        return result;
    }

    public String displayName() {
        return this.getClass().getName();
    }

    public void storePassphrase(String key, String displayName, CharSequence passphrase, boolean ignored) throws KeychainAccessException {
        this.getKeychainOrFail().storePassphrase(key, displayName, passphrase);
        this.setPassphraseStored(key, true);
    }

    public char[] loadPassphrase(String key) throws KeychainAccessException {
        char[] passphrase = this.getKeychainOrFail().loadPassphrase(key);
        this.setPassphraseStored(key, passphrase != null);
        return passphrase;
    }

    public void deletePassphrase(String key) throws KeychainAccessException {
        this.getKeychainOrFail().deletePassphrase(key);
        this.setPassphraseStored(key, false);
    }

    public void changePassphrase(String key, String displayName, CharSequence passphrase) throws KeychainAccessException {
        if (this.isPassphraseStored(key)) {
            this.getKeychainOrFail().changePassphrase(key, displayName, passphrase);
            this.setPassphraseStored(key, true);
        }
    }

    public boolean isSupported() {
        return this.keychain.getValue() != null;
    }

    public boolean isLocked() {
        return this.keychain.getValue() == null || ((KeychainAccessProvider)this.keychain.get()).isLocked();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPassphraseStored(String key) throws KeychainAccessException {
        char[] storedPw = null;
        try {
            storedPw = this.getKeychainOrFail().loadPassphrase(key);
            boolean bl = storedPw != null;
            return bl;
        }
        finally {
            if (storedPw != null) {
                Arrays.fill(storedPw, ' ');
            }
        }
    }

    private void setPassphraseStored(String key, boolean value) {
        BooleanProperty property = (BooleanProperty)this.passphraseStoredProperties.getIfPresent((Object)key);
        if (property != null) {
            if (Platform.isFxApplicationThread()) {
                property.set(value);
            } else {
                Platform.runLater(() -> property.set(value));
            }
        }
    }

    public ReadOnlyBooleanProperty getPassphraseStoredProperty(String key) {
        return (ReadOnlyBooleanProperty)this.passphraseStoredProperties.get((Object)key);
    }

    private BooleanProperty createStoredPassphraseProperty(String key) {
        try {
            return new SimpleBooleanProperty(this.isPassphraseStored(key));
        }
        catch (KeychainAccessException e) {
            return new SimpleBooleanProperty(false);
        }
    }
}

