/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.jimage;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Objects;
import java.util.stream.IntStream;
import jdk.internal.jimage.ImageBufferCache;
import jdk.internal.jimage.ImageHeader;
import jdk.internal.jimage.ImageLocation;
import jdk.internal.jimage.ImageStringsReader;
import jdk.internal.jimage.NativeImageBuffer;
import jdk.internal.jimage.decompressor.Decompressor;

public class BasicImageReader
implements AutoCloseable {
    private static final boolean IS_64_BIT = BasicImageReader.isSystemProperty("sun.arch.data.model", "64", "32");
    private static final boolean USE_JVM_MAP = BasicImageReader.isSystemProperty("jdk.image.use.jvm.map", "true", "true");
    private static final boolean MAP_ALL = BasicImageReader.isSystemProperty("jdk.image.map.all", "true", IS_64_BIT ? "true" : "false");
    private final Path imagePath;
    private final ByteOrder byteOrder;
    private final String name;
    private ByteBuffer memoryMap;
    private FileChannel channel;
    private final ImageHeader header;
    private final long indexSize;
    private IntBuffer redirect;
    private IntBuffer offsets;
    private ByteBuffer locations;
    private ByteBuffer strings;
    private final ImageStringsReader stringsReader;
    private final Decompressor decompressor;
    private Object cracResource;

    private static boolean isSystemProperty(final String key, final String value, final String def) {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return value.equals(System.getProperty(key, def));
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected BasicImageReader(Path path, ByteOrder byteOrder) throws IOException {
        this.imagePath = Objects.requireNonNull(path);
        this.byteOrder = Objects.requireNonNull(byteOrder);
        this.name = this.imagePath.toString();
        ByteBuffer map = USE_JVM_MAP && BasicImageReader.class.getClassLoader() == null ? NativeImageBuffer.getNativeMap(this.name) : null;
        if (map != null && MAP_ALL) {
            this.channel = null;
        } else {
            this.channel = this.openFileChannel();
            this.registerIfCracPresent();
        }
        if (MAP_ALL && map == null) {
            map = this.createMemoryMap(this.channel.size());
        }
        ByteBuffer headerBuffer = map;
        int headerSize = ImageHeader.getHeaderSize();
        if (headerBuffer == null) {
            headerBuffer = ByteBuffer.allocateDirect(headerSize);
            if (this.channel.read(headerBuffer, 0L) != headerSize) throw new IOException("\"" + this.name + "\" is not an image file");
            headerBuffer.rewind();
        } else if (headerBuffer.capacity() < headerSize) {
            throw new IOException("\"" + this.name + "\" is not an image file");
        }
        this.header = this.readHeader(this.intBuffer(headerBuffer, 0, headerSize));
        this.indexSize = this.header.getIndexSize();
        if (map == null) {
            map = this.createMemoryMap(this.indexSize);
        }
        this.memoryMap = map.asReadOnlyBuffer();
        if ((long)this.memoryMap.capacity() < this.indexSize) {
            throw new IOException("The image file \"" + this.name + "\" is corrupted");
        }
        this.initMappedBuffers();
        this.stringsReader = new ImageStringsReader(this);
        this.decompressor = new Decompressor();
    }

    protected void initMappedBuffers() {
        this.redirect = this.intBuffer(this.memoryMap, this.header.getRedirectOffset(), this.header.getRedirectSize());
        this.offsets = this.intBuffer(this.memoryMap, this.header.getOffsetsOffset(), this.header.getOffsetsSize());
        this.locations = BasicImageReader.slice(this.memoryMap, this.header.getLocationsOffset(), this.header.getLocationsSize());
        this.strings = BasicImageReader.slice(this.memoryMap, this.header.getStringsOffset(), this.header.getStringsSize());
    }

    protected ByteBuffer createMemoryMap(long size) throws IOException {
        return this.channel.map(FileChannel.MapMode.READ_ONLY, 0L, size);
    }

    private void registerIfCracPresent() {
        Class<?> priorityClass = null;
        try {
            priorityClass = Class.forName("jdk.internal.crac.Core$Priority");
        }
        catch (ClassNotFoundException e) {
            return;
        }
        try {
            ?[] priorities = priorityClass.getEnumConstants();
            if (priorities == null) {
                return;
            }
            Object normalPriority = null;
            for (int i = 0; i < priorities.length; ++i) {
                if (!"NORMAL".equals(priorities[i].toString())) continue;
                normalPriority = priorities[i];
            }
            if (normalPriority == null) {
                throw new IllegalStateException();
            }
            Class<?> resourceClass = Class.forName("jdk.internal.crac.mirror.Resource");
            Method getContextMethod = priorityClass.getMethod("getContext", new Class[0]);
            Object ctx = getContextMethod.invoke(normalPriority, new Object[0]);
            Class<?> ctxClass = ctx.getClass();
            this.registerCracResource(resourceClass, ctxClass, ctx);
        }
        catch (IllegalAccessException e) {
            this.registerIfPublicCracPresent();
        }
        catch (ClassNotFoundException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }

    private void registerIfPublicCracPresent() {
        Class<?> cracCoreClass = null;
        try {
            cracCoreClass = Class.forName("jdk.crac.Core");
        }
        catch (ClassNotFoundException e) {
            return;
        }
        try {
            Class<?> resourceClass = Class.forName("jdk.crac.Resource");
            Method getGlobalContextMethod = cracCoreClass.getMethod("getGlobalContext", new Class[0]);
            Object ctx = getGlobalContextMethod.invoke(null, new Object[0]);
            Class<?> ctxClass = Class.forName("jdk.crac.Context");
            this.registerCracResource(resourceClass, ctxClass, ctx);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }

    private void registerCracResource(Class<?> resourceClass, Class<?> ctxClass, Object ctx) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method registerMethod = ctxClass.getMethod("register", resourceClass);
        this.cracResource = Proxy.newProxyInstance(resourceClass.getClassLoader(), new Class[]{resourceClass}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if ("beforeCheckpoint".equals(method.getName())) {
                    BasicImageReader.this.channel.close();
                    BasicImageReader.this.redirect = null;
                    BasicImageReader.this.offsets = null;
                    BasicImageReader.this.locations = null;
                    BasicImageReader.this.strings = null;
                    BasicImageReader.this.memoryMap = null;
                } else if ("afterRestore".equals(method.getName())) {
                    if (BasicImageReader.this.channel != null) {
                        BasicImageReader.this.channel = BasicImageReader.this.openFileChannel();
                        BasicImageReader.this.memoryMap = BasicImageReader.this.createMemoryMap(MAP_ALL ? BasicImageReader.this.channel.size() : BasicImageReader.this.indexSize).asReadOnlyBuffer();
                        BasicImageReader.this.initMappedBuffers();
                    }
                } else {
                    if ("toString".equals(method.getName())) {
                        return BasicImageReader.this.toString();
                    }
                    if ("hashCode".equals(method.getName())) {
                        return 0;
                    }
                    if ("equals".equals(method.getName())) {
                        return args[0] == BasicImageReader.this.cracResource;
                    }
                    throw new UnsupportedOperationException(method.toString());
                }
                return null;
            }
        });
        registerMethod.invoke(ctx, this.cracResource);
    }

    private FileChannel openFileChannel() throws IOException {
        final FileChannel channel = FileChannel.open(this.imagePath, StandardOpenOption.READ);
        AccessController.doPrivileged(new PrivilegedAction<Void>(){
            final /* synthetic */ BasicImageReader this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public Void run() {
                if (BasicImageReader.class.getClassLoader() == null) {
                    try {
                        Class<?> fileChannelImpl = Class.forName("sun.nio.ch.FileChannelImpl");
                        Method setUninterruptible = fileChannelImpl.getMethod("setUninterruptible", new Class[0]);
                        setUninterruptible.invoke((Object)channel, new Object[0]);
                    }
                    catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                        // empty catch block
                    }
                }
                return null;
            }
        });
        return channel;
    }

    protected BasicImageReader(Path imagePath) throws IOException {
        this(imagePath, ByteOrder.nativeOrder());
    }

    public static BasicImageReader open(Path imagePath) throws IOException {
        return new BasicImageReader(imagePath, ByteOrder.nativeOrder());
    }

    public ImageHeader getHeader() {
        return this.header;
    }

    private ImageHeader readHeader(IntBuffer buffer) throws IOException {
        ImageHeader result = ImageHeader.readFrom(buffer);
        if (result.getMagic() != -889267494) {
            throw new IOException("\"" + this.name + "\" is not an image file");
        }
        if (result.getMajorVersion() != 1 || result.getMinorVersion() != 0) {
            throw new IOException("The image file \"" + this.name + "\" is not the correct version. Major: " + result.getMajorVersion() + ". Minor: " + result.getMinorVersion());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ByteBuffer slice(ByteBuffer buffer, int position, int capacity) {
        ByteBuffer byteBuffer = buffer;
        synchronized (byteBuffer) {
            buffer.limit(position + capacity);
            buffer.position(position);
            return buffer.slice();
        }
    }

    private IntBuffer intBuffer(ByteBuffer buffer, int offset, int size) {
        return BasicImageReader.slice(buffer, offset, size).order(this.byteOrder).asIntBuffer();
    }

    public static void releaseByteBuffer(ByteBuffer buffer) {
        Objects.requireNonNull(buffer);
        if (!MAP_ALL) {
            ImageBufferCache.releaseBuffer(buffer);
        }
    }

    public String getName() {
        return this.name;
    }

    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    public Path getImagePath() {
        return this.imagePath;
    }

    @Override
    public void close() throws IOException {
        if (this.channel != null) {
            this.channel.close();
        }
    }

    public ImageStringsReader getStrings() {
        return this.stringsReader;
    }

    public ImageLocation findLocation(String module, String name) {
        int index = this.getLocationIndex(module, name);
        if (index < 0) {
            return null;
        }
        long[] attributes = this.getAttributes(this.offsets.get(index));
        if (!ImageLocation.verify(module, name, attributes, this.stringsReader)) {
            return null;
        }
        return new ImageLocation(attributes, this.stringsReader);
    }

    public ImageLocation findLocation(String name) {
        int index = this.getLocationIndex(name);
        if (index < 0) {
            return null;
        }
        long[] attributes = this.getAttributes(this.offsets.get(index));
        if (!ImageLocation.verify(name, attributes, this.stringsReader)) {
            return null;
        }
        return new ImageLocation(attributes, this.stringsReader);
    }

    public boolean verifyLocation(String module, String name) {
        int index = this.getLocationIndex(module, name);
        if (index < 0) {
            return false;
        }
        int locationOffset = this.offsets.get(index);
        return ImageLocation.verify(module, name, this.locations, locationOffset, this.stringsReader);
    }

    public int getLocationIndex(String name) {
        int count = this.header.getTableLength();
        int index = this.redirect.get(ImageStringsReader.hashCode(name) % count);
        if (index < 0) {
            return -index - 1;
        }
        if (index > 0) {
            return ImageStringsReader.hashCode(name, index) % count;
        }
        return -1;
    }

    private int getLocationIndex(String module, String name) {
        int count = this.header.getTableLength();
        int index = this.redirect.get(ImageStringsReader.hashCode(module, name) % count);
        if (index < 0) {
            return -index - 1;
        }
        if (index > 0) {
            return ImageStringsReader.hashCode(module, name, index) % count;
        }
        return -1;
    }

    public String[] getEntryNames() {
        int[] attributeOffsets = new int[this.offsets.capacity()];
        this.offsets.get(attributeOffsets);
        return (String[])IntStream.of(attributeOffsets).filter(o -> o != 0).mapToObj(o -> ImageLocation.readFrom(this, o).getFullName()).sorted().toArray(String[]::new);
    }

    ImageLocation getLocation(int offset) {
        return ImageLocation.readFrom(this, offset);
    }

    public long[] getAttributes(int offset) {
        if (offset < 0 || offset >= this.locations.limit()) {
            throw new IndexOutOfBoundsException("offset");
        }
        return ImageLocation.decompress(this.locations, offset);
    }

    public String getString(int offset) {
        if (offset < 0 || offset >= this.strings.limit()) {
            throw new IndexOutOfBoundsException("offset");
        }
        return ImageStringsReader.stringFromByteBuffer(this.strings, offset);
    }

    public int match(int offset, String string, int stringOffset) {
        if (offset < 0 || offset >= this.strings.limit()) {
            throw new IndexOutOfBoundsException("offset");
        }
        return ImageStringsReader.stringFromByteBufferMatches(this.strings, offset, string, stringOffset);
    }

    private byte[] getBufferBytes(ByteBuffer buffer) {
        Objects.requireNonNull(buffer);
        byte[] bytes = new byte[buffer.limit()];
        buffer.get(bytes);
        return bytes;
    }

    private ByteBuffer readBuffer(long offset, long size) {
        int read;
        if (offset < 0L || Integer.MAX_VALUE <= offset) {
            throw new IndexOutOfBoundsException("Bad offset: " + offset);
        }
        if (size < 0L || Integer.MAX_VALUE <= size) {
            throw new IndexOutOfBoundsException("Bad size: " + size);
        }
        if (MAP_ALL) {
            ByteBuffer buffer = BasicImageReader.slice(this.memoryMap, (int)offset, (int)size);
            buffer.order(ByteOrder.BIG_ENDIAN);
            return buffer;
        }
        if (this.channel == null) {
            throw new InternalError("Image file channel not open");
        }
        ByteBuffer buffer = ImageBufferCache.getBuffer(size);
        try {
            read = this.channel.read(buffer, offset);
            buffer.rewind();
        }
        catch (IOException ex) {
            ImageBufferCache.releaseBuffer(buffer);
            throw new RuntimeException(ex);
        }
        if ((long)read != size) {
            ImageBufferCache.releaseBuffer(buffer);
            throw new RuntimeException("Short read: " + read + " instead of " + size + " bytes");
        }
        return buffer;
    }

    public byte[] getResource(String name) {
        Objects.requireNonNull(name);
        ImageLocation location = this.findLocation(name);
        return location != null ? this.getResource(location) : null;
    }

    public byte[] getResource(ImageLocation loc) {
        ByteBuffer buffer = this.getResourceBuffer(loc);
        if (buffer != null) {
            byte[] bytes = this.getBufferBytes(buffer);
            ImageBufferCache.releaseBuffer(buffer);
            return bytes;
        }
        return null;
    }

    public ByteBuffer getResourceBuffer(ImageLocation loc) {
        Objects.requireNonNull(loc);
        long offset = loc.getContentOffset() + this.indexSize;
        long compressedSize = loc.getCompressedSize();
        long uncompressedSize = loc.getUncompressedSize();
        if (compressedSize < 0L || Integer.MAX_VALUE < compressedSize) {
            throw new IndexOutOfBoundsException("Bad compressed size: " + compressedSize);
        }
        if (uncompressedSize < 0L || Integer.MAX_VALUE < uncompressedSize) {
            throw new IndexOutOfBoundsException("Bad uncompressed size: " + uncompressedSize);
        }
        if (compressedSize == 0L) {
            return this.readBuffer(offset, uncompressedSize);
        }
        ByteBuffer buffer = this.readBuffer(offset, compressedSize);
        if (buffer != null) {
            byte[] bytesOut;
            byte[] bytesIn = this.getBufferBytes(buffer);
            ImageBufferCache.releaseBuffer(buffer);
            try {
                bytesOut = this.decompressor.decompressResource(this.byteOrder, strOffset -> this.getString(strOffset), bytesIn);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
            return ByteBuffer.wrap(bytesOut);
        }
        return null;
    }

    public InputStream getResourceStream(ImageLocation loc) {
        Objects.requireNonNull(loc);
        byte[] bytes = this.getResource(loc);
        return new ByteArrayInputStream(bytes);
    }
}

